/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.listeners;

import javax.security.auth.Subject;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.ext.authentication.AuthenticationException;
import net.sf.jguard.ext.authentication.manager.AuthenticationManagerFactory;
import net.sf.jguard.ext.registration.SubjectTemplate;
import net.sf.jguard.ext.util.SubjectUtils;
import net.sf.jguard.jee.authentication.http.HttpAuthenticationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionAttributeListener
implements HttpSessionAttributeListener {
    public static final Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jguard$jee$listeners$SessionAttributeListener == null ? (class$net$sf$jguard$jee$listeners$SessionAttributeListener = SessionAttributeListener.class$("net.sf.jguard.jee.listeners.SessionAttributeListener")) : class$net$sf$jguard$jee$listeners$SessionAttributeListener));
    static /* synthetic */ Class class$net$sf$jguard$jee$listeners$SessionAttributeListener;

    public void attributeAdded(HttpSessionBindingEvent event) {
        if (event.getName().equals("authenticationUtils")) {
            JGuardCredential identity = null;
            try {
                identity = this.getIdentityCredential(event);
                logger.info("subject with identityCredential=" + identity + " is created ");
            }
            catch (AuthenticationException ex) {
                logger.warn(ex.getMessage());
            }
        }
    }

    private JGuardCredential getIdentityCredential(HttpSessionBindingEvent event) throws AuthenticationException {
        Subject subject = ((HttpAuthenticationUtils)event.getValue()).getSubject();
        JGuardCredential identity = SubjectUtils.getIdentityCredential((Subject)subject, (SubjectTemplate)AuthenticationManagerFactory.getAuthenticationManager().getDefaultSubjectTemplate());
        return identity;
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if (event.getName().equals("authenticationUtils")) {
            JGuardCredential identity = null;
            try {
                identity = this.getIdentityCredential(event);
                logger.info("subject with identityCredential=" + identity + " is removed ");
            }
            catch (AuthenticationException ex) {
                logger.warn(ex.getMessage());
            }
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        if (event.getName().equals("authenticationUtils")) {
            JGuardCredential identity = null;
            try {
                identity = this.getIdentityCredential(event);
                logger.info("subject with identityCredential=" + identity + " is replaced ");
            }
            catch (AuthenticationException ex) {
                logger.warn(ex.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

