/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authorization.http;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import net.sf.jguard.ext.AccessContext;
import net.sf.jguard.ext.authorization.AuthorizationLifeCycle;
import net.sf.jguard.ext.authorization.AuthorizationPhases;

public class ServletAuthorizationFilter
implements Filter {
    private AuthorizationLifeCycle lifeCycle = null;
    public static final String SERVLET_REQUEST = "servletRequest";
    public static final String SERVLET_RESPONSE = "servletResponse";
    public static final String FILTER_CHAIN = "filterChain";

    public void init(FilterConfig filterConfig) throws ServletException {
        String authorizationPhasesImpl = filterConfig.getInitParameter("authorizationPhases");
        AuthorizationPhases phases = null;
        try {
            phases = (AuthorizationPhases)Thread.currentThread().getContextClassLoader().loadClass(authorizationPhasesImpl).newInstance();
        }
        catch (InstantiationException iex) {
            throw new ServletException(iex.getMessage());
        }
        catch (ClassNotFoundException cne) {
            throw new ServletException(cne.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new ServletException(iae.getMessage());
        }
        this.lifeCycle = new AuthorizationLifeCycle(phases);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response;
        if (servletResponse instanceof HttpServletResponse && (response = (HttpServletResponse)servletResponse).isCommitted()) {
            return;
        }
        AccessContext context = new AccessContext();
        context.addParameter(SERVLET_REQUEST, (Object)servletRequest);
        context.addParameter(SERVLET_RESPONSE, (Object)servletResponse);
        context.addParameter(FILTER_CHAIN, (Object)filterChain);
        this.lifeCycle.process(context);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

