/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authorization.http;

import java.io.IOException;
import java.security.Permission;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import net.sf.jguard.ext.AccessContext;
import net.sf.jguard.ext.authorization.AuthorizationPhases;
import net.sf.jguard.jee.authentication.http.HttpAuthenticationUtils;
import net.sf.jguard.jee.authorization.http.HttpPermissionFactory;
import net.sf.jguard.jee.authorization.http.PermissionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletAuthorizationPhases
implements AuthorizationPhases {
    public static final Logger logger = LoggerFactory.getLogger((String)(class$net$sf$jguard$jee$authorization$http$HttpServletAuthorizationPhases == null ? (class$net$sf$jguard$jee$authorization$http$HttpServletAuthorizationPhases = HttpServletAuthorizationPhases.class$("net.sf.jguard.jee.authorization.http.HttpServletAuthorizationPhases")) : class$net$sf$jguard$jee$authorization$http$HttpServletAuthorizationPhases).getName());
    private PermissionFactory permissionFactory = new HttpPermissionFactory();
    static /* synthetic */ Class class$net$sf$jguard$jee$authorization$http$HttpServletAuthorizationPhases;

    public Permission getPermissionRequested(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        return this.permissionFactory.getPermission((ServletRequest)request);
    }

    public void setLastAccessDeniedPermission(AccessContext context, Permission permission) {
        if (permission instanceof URLPermission) {
            URLPermission urlPermission = (URLPermission)permission;
            HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
            HttpSession session = request.getSession(true);
            session.setAttribute("lastAccessDeniedURI", (Object)urlPermission.getURI());
        }
    }

    public void accessDenied(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getParameter("servletResponse");
        if (logger.isDebugEnabled()) {
            logger.debug(" access denied to " + request.getRequestURI());
        }
        logger.debug(" access is denied to " + request.getRequestURI() + " accessDeniedURI is not defined  jGuard send 401 http code ");
        response.setStatus(401);
        try {
            if (!response.isCommitted()) {
                response.sendError(401, "access is denied to " + request.getRequestURI());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void authorize(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getParameter("servletResponse");
        FilterChain chain = (FilterChain)context.getParameter("filterChain");
        if (logger.isDebugEnabled()) {
            logger.debug("doFilter() -  access authorized to " + request.getRequestURI());
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable t) {
            logger.error(t.getMessage());
            try {
                response.sendError(503);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    public Subject getSubject(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        HttpSession session = request.getSession(true);
        Subject subject = HttpAuthenticationUtils.getSubject(session);
        return subject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

