/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authorization.http;

import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.jguard.core.authorization.policy.AccessControllerUtils;
import net.sf.jguard.jee.authentication.http.HttpAuthenticationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAccessControllerUtils {
    public static final Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jguard$jee$authorization$http$HttpAccessControllerUtils == null ? (class$net$sf$jguard$jee$authorization$http$HttpAccessControllerUtils = HttpAccessControllerUtils.class$("net.sf.jguard.jee.authorization.http.HttpAccessControllerUtils")) : class$net$sf$jguard$jee$authorization$http$HttpAccessControllerUtils));
    static /* synthetic */ Class class$net$sf$jguard$jee$authorization$http$HttpAccessControllerUtils;

    public static AccessControllerUtils getAuthorizationUtils(HttpSession session) {
        AccessControllerUtils authUtils = (AccessControllerUtils)session.getServletContext().getAttribute("authorizationUtils");
        return authUtils;
    }

    public static void checkPermission(HttpSession session, Permission p) throws AccessControlException, PrivilegedActionException {
        if (session == null) {
            throw new AccessControlException(" user is not yet authenticated ", p);
        }
        AccessControllerUtils authZUtils = HttpAccessControllerUtils.getAuthorizationUtils(session);
        Subject subject = HttpAuthenticationUtils.getSubject(session);
        if (subject == null) {
            throw new AccessControlException(" user is not yet authenticated ", p);
        }
        AccessControllerUtils.checkPermission((Subject)subject, (Permission)p);
    }

    public static boolean hasPermission(HttpServletRequest request, Permission p) {
        boolean result = true;
        try {
            HttpAccessControllerUtils.checkPermission(request.getSession(true), p);
        }
        catch (AccessControlException ace) {
            logger.debug(ace.getMessage());
            result = false;
        }
        catch (PrivilegedActionException pae) {
            logger.debug(pae.getMessage());
            result = false;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

