/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.io.IOException;
import java.security.Policy;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.jguard.ext.AccessContext;
import net.sf.jguard.ext.authentication.AuthenticationLifeCycle;
import net.sf.jguard.ext.authentication.AuthenticationPhases;
import net.sf.jguard.jee.util.WebappUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletAuthenticationFilter
implements Filter {
    private AuthenticationLifeCycle lifeCycle = null;
    public static final Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jguard$jee$authentication$http$ServletAuthenticationFilter == null ? (class$net$sf$jguard$jee$authentication$http$ServletAuthenticationFilter = ServletAuthenticationFilter.class$("net.sf.jguard.jee.authentication.http.ServletAuthenticationFilter")) : class$net$sf$jguard$jee$authentication$http$ServletAuthenticationFilter));
    public static final String SERVLET_REQUEST = "servletRequest";
    public static final String SERVLET_RESPONSE = "servletResponse";
    public static final String FILTER_CHAIN = "filterChain";
    private static String applicationName;
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$http$ServletAuthenticationFilter;

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.debug("server info = " + filterConfig.getServletContext().getServerInfo());
        logger.debug("servletContextName=" + filterConfig.getServletContext().getServletContextName());
        logger.debug("servlet Real Path=" + WebappUtil.getWebappHomePath(filterConfig.getServletContext(), "/"));
        logger.debug("current Policy=" + Policy.getPolicy());
        ServletContext context = filterConfig.getServletContext();
        applicationName = context.getServletContextName();
        if (applicationName == null) {
            logger.error(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
            throw new ServletException(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
        }
        String authenticationPhasesImpl = filterConfig.getInitParameter("authenticationPhases");
        String filterConfigurationLocation = WebappUtil.getWebappHomePath(context, filterConfig.getInitParameter("configurationLocation"));
        AuthenticationPhases phases = null;
        try {
            phases = (AuthenticationPhases)Thread.currentThread().getContextClassLoader().loadClass(authenticationPhasesImpl).newInstance();
            String authenticationScope = (String)context.getAttribute("authenticationScope");
            phases.init(filterConfigurationLocation, authenticationScope);
        }
        catch (InstantiationException iex) {
            throw new ServletException(iex.getMessage());
        }
        catch (ClassNotFoundException cne) {
            throw new ServletException(cne.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new ServletException(iae.getMessage());
        }
        this.lifeCycle = new AuthenticationLifeCycle(phases);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        AccessContext context = new AccessContext();
        context.addParameter(SERVLET_REQUEST, (Object)servletRequest);
        context.addParameter(SERVLET_RESPONSE, (Object)servletResponse);
        context.addParameter(FILTER_CHAIN, (Object)filterChain);
        this.lifeCycle.process(context);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

