/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jguard.core.authentication.AbstractAuthenticationBindings;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.AuthenticationBindings;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import net.sf.jguard.ext.authentication.AuthenticationException;
import net.sf.jguard.ext.authentication.manager.AuthenticationManager;
import net.sf.jguard.ext.authentication.manager.AuthenticationManagerFactory;
import net.sf.jguard.ext.registration.SubjectTemplate;
import net.sf.jguard.ext.util.CryptUtils;
import net.sf.jguard.ext.util.XMLUtils;
import net.sf.jguard.jee.authentication.callbacks.HttpServletCallbackHandler;
import net.sf.jguard.jee.authentication.http.AnonymizerRequestWrapper;
import net.sf.jguard.jee.authentication.http.AuthSchemesHelper;
import net.sf.jguard.jee.authentication.http.HttpAuthenticationUtils;
import net.sf.jguard.jee.authentication.http.JGuardServletRequestWrapper;
import net.sf.jguard.jee.authorization.http.HttpAccessControllerUtils;
import net.sf.jguard.jee.authorization.http.HttpPermissionFactory;
import net.sf.jguard.jee.authorization.http.PermissionFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletAuthenticationBindings
extends AbstractAuthenticationBindings
implements AuthenticationBindings {
    private static final Logger logger = LoggerFactory.getLogger((String)(class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings == null ? (class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings = HttpServletAuthenticationBindings.class$("net.sf.jguard.jee.authentication.http.HttpServletAuthenticationBindings")) : class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings).getName());
    private String authScheme = null;
    private URLPermission authenticationFailedPermission = null;
    private String indexURI;
    private boolean goToLastAccessDeniedUriOnSuccess;
    private boolean local = false;
    private URLPermission registerProcessPermission;
    private URLPermission registerPermission;
    private URLPermission logonProcessPermission;
    private static URLPermission logonPermission;
    private String logonURI;
    private String registerURI;
    private PermissionFactory permissionFactory = new HttpPermissionFactory();
    private URLPermission logoffPermission;
    private URLPermission indexPermission;
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings;

    public void init(String location, String authenticationScope) {
        Map settings = this.loadFilterConfiguration(location);
        this.setSettings(settings);
        this.local = !"jvm".equalsIgnoreCase(authenticationScope);
    }

    private void setSettings(Map settings) {
        String tmpValue;
        this.indexURI = (String)settings.get("indexURI");
        this.indexPermission = new URLPermission("indexURI", this.indexURI);
        this.authenticationFailedPermission = new URLPermission("authenticationFailedURI", (String)settings.get("authenticationFailedURI"));
        this.logonProcessPermission = new URLPermission("logonProcessURI", (String)settings.get("logonProcessURI"));
        String logonURIStr = (String)settings.get("logonURI");
        logonPermission = new URLPermission("logonURI", logonURIStr);
        this.logoffPermission = new URLPermission("logoffURI", (String)settings.get("logoffURI"));
        this.registerProcessPermission = new URLPermission("registerProcessURI", (String)settings.get("registerProcessURI"));
        this.registerURI = (String)settings.get("registerURI");
        this.registerPermission = new URLPermission("registerURI", this.registerURI);
        this.authScheme = (String)settings.get("authScheme");
        HttpServletCallbackHandler.setAuthScheme(this.authScheme);
        Collection authSchemes = AuthSchemesHelper.validateAuthScheme(this.authScheme);
        if (authSchemes.contains("FORM")) {
            HttpServletCallbackHandler.setLoginField((String)settings.get("loginField"));
            HttpServletCallbackHandler.setPasswordField((String)settings.get("passwordField"));
        }
        if ("false".equalsIgnoreCase(tmpValue = (String)settings.get("goToLastAccessDeniedUriOnSuccess")) || "no".equalsIgnoreCase(tmpValue)) {
            this.goToLastAccessDeniedUriOnSuccess = false;
        }
    }

    public void logonProcess(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getParameter("servletResponse");
        HttpSession session = request.getSession(true);
        Subject subject = HttpAuthenticationUtils.getSubject(session);
        if ("BASIC".equalsIgnoreCase(this.authScheme)) {
            String authorizationHeader = request.getHeader("Authorization");
            logger.debug("authorizationHeader=" + authorizationHeader);
            if (subject == null) {
                String AuthorizationHeaderValue = HttpServletCallbackHandler.buildBasicAuthHeader("guest", "guest", request.getCharacterEncoding());
                JGuardServletRequestWrapper jguardrequest = new JGuardServletRequestWrapper(request);
                jguardrequest.setHeader("Authorization", AuthorizationHeaderValue);
                logger.debug(" BASIC authentication subject is null  authenticate phase ");
                this.authenticate(context);
            } else if (authorizationHeader == null || !authorizationHeader.startsWith("Basic ")) {
                logger.debug(" subject is not null but BASIC HEADER is incorrect " + authorizationHeader, (Object)" jGuard build BASIC challenge  ");
                HttpServletCallbackHandler.buildBasicChallenge(response, (String)session.getServletContext().getAttribute("applicationName"));
            } else {
                logger.debug(" BASIC AUTHENTICATION TYPE   authenticate phase  ");
                this.authenticate(context);
            }
        } else {
            logger.debug(" AUTHENTICATION TYPE =" + this.authScheme + "  authenticate phase  ");
            this.authenticate(context);
        }
    }

    public void logoff(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        HttpSession session = request.getSession();
        HttpAuthenticationUtils auth = (HttpAuthenticationUtils)session.getAttribute("authenticationUtils");
        if (auth != null) {
            auth.logout();
            logger.debug(" user logoff ");
        }
        session.removeAttribute("authenticationUtils");
        if (logger.isDebugEnabled()) {
            logger.debug("doFilter() -  user logoff ");
        }
        try {
            session.invalidate();
        }
        catch (IllegalStateException ise) {
            logger.debug(" session is already invalidated ");
        }
    }

    public boolean authenticate(AccessContext context) {
        boolean authenticationFailed;
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getParameter("servletResponse");
        try {
            authenticationFailed = !HttpAuthenticationUtils.authenticate(request, response, false, this.local);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
            return false;
        }
        return this.postAuthenticationProcess(context, authenticationFailed);
    }

    public void process(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        context.putParameter("servletRequest", (Object)new JGuardServletRequestWrapper(request));
    }

    public void accessDenied(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getParameter("servletResponse");
        if (logger.isDebugEnabled()) {
            logger.debug(" access denied to " + request.getRequestURI());
        }
        logger.debug(" access is denied to " + request.getRequestURI() + " accessDeniedURI is not defined  jGuard send 401 http code ");
        response.setStatus(401);
        try {
            response.sendError(401, "access is denied to " + request.getRequestURI());
        }
        catch (IOException ex) {
            try {
                response.sendError(500);
            }
            catch (IOException ex2) {
                throw new RuntimeException(ex2.getMessage());
            }
        }
    }

    public void redirectToLogon(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getParameter("servletResponse");
        try {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + this.logonURI));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public Subject getSubject(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        HttpSession session = request.getSession(true);
        Subject subject = HttpAuthenticationUtils.getSubject(session);
        return subject;
    }

    public Permission getPermissionRequested(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        return this.permissionFactory.getPermission((ServletRequest)request);
    }

    public void setLastAccessDeniedPermission(AccessContext context, Permission permission) {
        if (permission instanceof URLPermission) {
            URLPermission urlPermission = (URLPermission)permission;
            HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
            HttpSession session = request.getSession(true);
            session.setAttribute("lastAccessDeniedURI", (Object)urlPermission.getURI());
        }
    }

    public Permission getAuthenticationFailedPermission() {
        return this.authenticationFailedPermission;
    }

    public Permission getLogonPermission() {
        return logonPermission;
    }

    public Permission getLogonProcessPermission() {
        return this.logonProcessPermission;
    }

    public Permission getIndexPermission() {
        return this.indexPermission;
    }

    public Permission getLogoffPermission() {
        return this.logoffPermission;
    }

    public Permission getRegisterProcessPermission() {
        return this.registerProcessPermission;
    }

    public Permission getRegisterPermission() {
        return this.registerPermission;
    }

    private boolean postAuthenticationProcess(AccessContext context, boolean authenticationFailed) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getParameter("servletResponse");
        Subject subject = HttpAuthenticationUtils.getSubject(request.getSession(true));
        if (authenticationFailed) {
            if (response.isCommitted()) {
                logger.warn(" response is already committed ");
            }
            if ("BASIC".equalsIgnoreCase(this.authScheme)) {
                HttpServletCallbackHandler.buildBasicChallenge(response, (String)request.getSession(true).getServletContext().getAttribute("applicationName"));
                return !authenticationFailed;
            }
            logger.debug("authentication failed redirect to " + this.authenticationFailedPermission.getURI());
            if (this.authenticationFailedPermission != null && !this.authenticationFailedPermission.getURI().equals("")) {
                try {
                    response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + this.authenticationFailedPermission.getURI()));
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage());
                    return false;
                }
                logger.debug(" NOT BASIC AUTHENTICATION - user is not authenticated  redirect to " + request.getContextPath() + this.authenticationFailedPermission.getURI());
            } else {
                this.accessDenied(context);
            }
        } else {
            HttpSession oldSession = request.getSession(true);
            String redirectURI = this.indexURI;
            String lastAccessDeniedURI = (String)oldSession.getAttribute("lastAccessDeniedURI");
            HttpAuthenticationUtils httpAuthenticationUtils = HttpAuthenticationUtils.getHttpAuthenticationUtils(request, this.local);
            subject = httpAuthenticationUtils.getSubject();
            if (!response.isCommitted()) {
                oldSession.removeAttribute("authenticationUtils");
                oldSession.invalidate();
                HttpSession newSession = request.getSession(true);
                newSession.setAttribute("authenticationUtils", (Object)httpAuthenticationUtils);
            }
            if (lastAccessDeniedURI != null && lastAccessDeniedURI != "") {
                if (this.goToLastAccessDeniedUriOnSuccess) {
                    redirectURI = lastAccessDeniedURI;
                } else if (!HttpAccessControllerUtils.hasPermission(request, (Permission)this.indexPermission)) {
                    redirectURI = this.logonURI;
                }
            }
            logger.debug(" user is authenticated ", (Object)(" redirect to " + redirectURI));
            if (!response.isCommitted()) {
                try {
                    response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + redirectURI));
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage());
                    return false;
                }
            }
        }
        return !authenticationFailed;
    }

    private Map loadFilterConfiguration(String configurationLocation) {
        Element goToLastAccessDeniedUriOnSuccessElement;
        Element passwordElement;
        Document doc = XMLUtils.read((String)configurationLocation);
        Element authentication = doc.getRootElement().element("filter");
        HashMap<String, String> filterSettings = new HashMap<String, String>();
        filterSettings.put("indexURI", authentication.element("indexURI").getTextTrim());
        filterSettings.put("authenticationFailedURI", authentication.element("authenticationFailedURI").getTextTrim());
        if (authentication.element("registerProcessURI") != null) {
            filterSettings.put("registerProcessURI", authentication.element("registerProcessURI").getTextTrim());
        }
        if (authentication.element("registerURI") != null) {
            filterSettings.put("registerURI", authentication.element("registerURI").getTextTrim());
        }
        filterSettings.put("logonProcessURI", authentication.element("logonProcessURI").getTextTrim());
        filterSettings.put("logonURI", authentication.element("logonURI").getTextTrim());
        filterSettings.put("logoffURI", authentication.element("logoffURI").getTextTrim());
        filterSettings.put("authScheme", authentication.element("authScheme").getTextTrim());
        Element loginElement = authentication.element("loginField");
        if (loginElement != null) {
            filterSettings.put("loginField", loginElement.getTextTrim());
        }
        if ((passwordElement = authentication.element("passwordField")) != null) {
            filterSettings.put("passwordField", passwordElement.getTextTrim());
        }
        if ((goToLastAccessDeniedUriOnSuccessElement = authentication.element("goToLastAccessDeniedUriOnSuccess")) != null) {
            filterSettings.put("goToLastAccessDeniedUriOnSuccess", goToLastAccessDeniedUriOnSuccessElement.getTextTrim());
        }
        return filterSettings;
    }

    public AccessContext anonymize(AccessContext context) {
        AccessContext accContext = (AccessContext)context.clone();
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        accContext.putParameter("servletRequest", (Object)new AnonymizerRequestWrapper(request));
        return accContext;
    }

    public boolean registerCoreProcess(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        boolean success = false;
        AuthenticationManager auth = AuthenticationManagerFactory.getAuthenticationManager();
        SubjectTemplate st = null;
        try {
            st = HttpServletAuthenticationBindings.buildSubjectTemplate(request);
        }
        catch (AuthenticationException e1) {
            logger.error(" subject template cannot be built ", (Throwable)e1);
            success = false;
            return false;
        }
        String passwordField = HttpServletCallbackHandler.getPasswordField();
        Set credentials = st.getRequiredCredentials();
        Iterator itCreds = credentials.iterator();
        boolean found = false;
        JGuardCredential passwordCredential = null;
        while (itCreds.hasNext() && !found) {
            JGuardCredential cred = (JGuardCredential)itCreds.next();
            if (!cred.getId().equals(passwordField)) continue;
            passwordCredential = cred;
            found = true;
        }
        if (!found) {
            logger.warn("JGuardCredential matching  passwordField not found in the SubjectTemplate");
            success = false;
            return success;
        }
        char[] password = ((String)passwordCredential.getValue()).toCharArray();
        try {
            passwordCredential.setValue((Object)new String(CryptUtils.cryptPassword((char[])password)));
        }
        catch (NoSuchAlgorithmException ex) {
            logger.warn(ex.getMessage());
            success = false;
            return success;
        }
        try {
            auth.createUser(st);
            success = true;
        }
        catch (AuthenticationException e) {
            logger.debug(" registrationProcess failed ");
            success = false;
        }
        return success;
    }

    private static SubjectTemplate buildSubjectTemplate(HttpServletRequest req) throws AuthenticationException {
        AuthenticationManager auth = AuthenticationManagerFactory.getAuthenticationManager();
        SubjectTemplate defaultSt = auth.getDefaultSubjectTemplate();
        SubjectTemplate st = new SubjectTemplate();
        st.setName(defaultSt.getName());
        Set privateCredRequiredFromDefaultSt = defaultSt.getPrivateRequiredCredentials();
        Set privRequiredCred = HttpServletAuthenticationBindings.grabRegistrationForm(req, st, privateCredRequiredFromDefaultSt);
        st.setPrivateRequiredCredentials(privRequiredCred);
        Set publicCredRequiredFromDefaultSt = defaultSt.getPublicRequiredCredentials();
        Set pubRequiredCred = HttpServletAuthenticationBindings.grabRegistrationForm(req, st, publicCredRequiredFromDefaultSt);
        st.setPublicRequiredCredentials(pubRequiredCred);
        Set publicCredOptionalFromDefaultSt = defaultSt.getPublicOptionalCredentials();
        Set pubOptionalCred = HttpServletAuthenticationBindings.grabRegistrationForm(req, st, publicCredOptionalFromDefaultSt);
        st.setPublicOptionalCredentials(pubOptionalCred);
        Set privateCredOptionalFromDefaultSt = defaultSt.getPrivateOptionalCredentials();
        Set privOptionalCred = HttpServletAuthenticationBindings.grabRegistrationForm(req, st, privateCredOptionalFromDefaultSt);
        st.setPrivateOptionalCredentials(privOptionalCred);
        return st;
    }

    private static Set grabRegistrationForm(HttpServletRequest req, SubjectTemplate st, Set credentialsFromDefaultSt) {
        Iterator itCredentials = credentialsFromDefaultSt.iterator();
        HashSet<JGuardCredential> credSet = new HashSet<JGuardCredential>();
        while (itCredentials.hasNext()) {
            JGuardCredential jcredFromDefault = (JGuardCredential)itCredentials.next();
            if (req.getParameter(jcredFromDefault.getId()) == null) continue;
            JGuardCredential jcred = new JGuardCredential();
            jcred.setId(jcredFromDefault.getId());
            try {
                jcred.setValue((Object)req.getParameter(jcredFromDefault.getId()));
                credSet.add(jcred);
            }
            catch (IllegalArgumentException iae) {
                logger.warn(" the property " + jcredFromDefault.getId() + " doesn't exist in the HttpServletRequest ");
            }
        }
        return credSet;
    }

    public void registerProcess(AccessContext context) {
        boolean registerSucceed = this.registerCoreProcess(context);
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getParameter("servletResponse");
        if (!registerSucceed) {
            logger.debug(" registration failed ", (Object)" registerProcess phase ");
            if (!response.isCommitted()) {
                try {
                    response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + this.registerURI));
                }
                catch (IOException e) {
                    logger.warn(" we cannot redirect to " + request.getContextPath() + this.registerURI + " because " + e.getMessage());
                }
            } else {
                logger.warn(" we cannot redirect to " + request.getContextPath() + this.registerURI + " because response is already commited ");
            }
        } else if (registerSucceed) {
            logger.debug(" registration succeed ", (Object)" registerProcess phase ");
            request.getSession(true).removeAttribute("authenticationUtils");
            request.getSession(true).removeAttribute("lastAccessDeniedURI");
            this.authenticateAfterRegistration(context);
        }
    }

    private boolean authenticateAfterRegistration(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getParameter("servletResponse");
        try {
            boolean authenticationFailed = !HttpAuthenticationUtils.authenticate(request, response, true, this.local);
            return this.postAuthenticationProcess(context, authenticationFailed);
        }
        catch (IOException e) {
            logger.warn(e.getMessage());
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

