/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.io.IOException;
import java.util.Collection;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import net.sf.jguard.ext.authentication.manager.AuthenticationUtils;
import net.sf.jguard.jee.authentication.callbacks.HttpServletCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAuthenticationUtils
implements HttpSessionActivationListener,
HttpSessionBindingListener {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jguard$jee$authentication$http$HttpAuthenticationUtils == null ? (class$net$sf$jguard$jee$authentication$http$HttpAuthenticationUtils = HttpAuthenticationUtils.class$("net.sf.jguard.jee.authentication.http.HttpAuthenticationUtils")) : class$net$sf$jguard$jee$authentication$http$HttpAuthenticationUtils));
    private AuthenticationUtils authenticationUtils = null;
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$http$HttpAuthenticationUtils;

    public HttpAuthenticationUtils() {
        this.authenticationUtils = new AuthenticationUtils();
    }

    public HttpAuthenticationUtils(Configuration configuration) {
        this.authenticationUtils = new AuthenticationUtils(configuration);
    }

    private void useLoginContext(HttpServletRequest request, HttpServletResponse response, boolean afterRegistration) throws LoginException {
        HttpSession session = request.getSession(true);
        String applicationName = (String)session.getServletContext().getAttribute("applicationName");
        HttpServletCallbackHandler cbh = new HttpServletCallbackHandler(request, response);
        cbh.setAfterRegistration(afterRegistration);
        this.authenticationUtils.login(applicationName, (CallbackHandler)cbh, request.getLocale());
    }

    public Subject getSubject() {
        return this.authenticationUtils.getSubject();
    }

    public static HttpAuthenticationUtils getHttpAuthenticationUtils(HttpServletRequest req, boolean local) {
        HttpSession session = req.getSession(true);
        HttpAuthenticationUtils httpAuthenticationUtils = (HttpAuthenticationUtils)session.getAttribute("authenticationUtils");
        if (httpAuthenticationUtils != null && httpAuthenticationUtils.getSubject() == null) {
            logger.debug(" subject into HttpAuthenticationUtils is null ");
            httpAuthenticationUtils.logout();
            session.removeAttribute("authenticationUtils");
            httpAuthenticationUtils = null;
        }
        if (httpAuthenticationUtils == null) {
            Configuration configuration = (Configuration)req.getSession().getServletContext().getAttribute("jGuardConfiguration");
            httpAuthenticationUtils = local ? new HttpAuthenticationUtils(configuration) : new HttpAuthenticationUtils();
            session.setAttribute("authenticationUtils", (Object)httpAuthenticationUtils);
        }
        return httpAuthenticationUtils;
    }

    public static boolean authenticate(HttpServletRequest req, HttpServletResponse res, boolean afterRegistration, boolean local) throws IOException {
        HttpAuthenticationUtils auth = HttpAuthenticationUtils.getHttpAuthenticationUtils(req, local);
        HttpSession session = req.getSession(true);
        boolean authenticationSucceed = true;
        try {
            auth.useLoginContext(req, res, afterRegistration);
        }
        catch (LoginException e) {
            authenticationSucceed = false;
            String messageError = null;
            messageError = e.getLocalizedMessage();
            session.setAttribute("LoginExceptionMessage", (Object)messageError);
            session.setAttribute("LoginExceptionClass", e.getClass());
        }
        return authenticationSucceed;
    }

    public void sessionWillPassivate(HttpSessionEvent sessionEvent) {
        HttpAuthenticationUtils authUtils;
        if (this.authenticationUtils != null) {
            this.authenticationUtils.logout();
        }
        if ((authUtils = (HttpAuthenticationUtils)sessionEvent.getSession().getAttribute("authenticationUtils")) != null) {
            authUtils.logout();
        }
        sessionEvent.getSession().removeAttribute("authenticationUtils");
    }

    public void sessionDidActivate(HttpSessionEvent sessionEvent) {
    }

    public void valueBound(HttpSessionBindingEvent bindingEvent) {
        if ("authenticationUtils".equals(bindingEvent.getName())) {
            Collection users = (Collection)bindingEvent.getSession().getServletContext().getAttribute("sessionList");
            users.add(this);
        }
    }

    public void valueUnbound(HttpSessionBindingEvent bindingEvent) {
        Collection users;
        if ("authenticationUtils".equals(bindingEvent.getName()) && (users = (Collection)bindingEvent.getSession().getServletContext().getAttribute("sessionList")) != null && users.contains(this)) {
            users.remove(this);
        }
    }

    public void logout() {
        this.authenticationUtils.logout();
    }

    public AuthenticationUtils getAuthenticationUtils() {
        return this.authenticationUtils;
    }

    public static Subject getSubject(HttpSession session) {
        HttpAuthenticationUtils authutils = (HttpAuthenticationUtils)session.getAttribute("authenticationUtils");
        if (authutils != null) {
            return authutils.getSubject();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

