/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.security.Permission;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import net.sf.jguard.ext.AccessContext;
import net.sf.jguard.jee.authentication.http.AccessPhases;

public class AccessLifeCycle {
    public static final Logger logger = Logger.getLogger((class$net$sf$jguard$jee$authentication$http$AccessLifeCycle == null ? (class$net$sf$jguard$jee$authentication$http$AccessLifeCycle = AccessLifeCycle.class$("net.sf.jguard.jee.authentication.http.AccessLifeCycle")) : class$net$sf$jguard$jee$authentication$http$AccessLifeCycle).getName());
    private AccessPhases phases = null;
    private Permission authenticationFailed = null;
    private Permission logon = null;
    private Permission logonProcess = null;
    private Permission logoff = null;
    private Permission registerProcess = null;
    private Permission register = null;
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$http$AccessLifeCycle;

    public AccessLifeCycle(AccessPhases phases) {
        this.phases = phases;
        this.authenticationFailed = phases.getAuthenticationFailedPermission();
        this.logon = phases.getLogonPermission();
        this.logonProcess = phases.getLogonProcessPermission();
        this.logoff = phases.getLogoffPermission();
        this.registerProcess = phases.getregisterProcessPermission();
        this.register = phases.getregisterPermission();
    }

    public void process(AccessContext context) {
        Permission permission = this.phases.getPermission(context);
        Subject subject = this.phases.getSubject(context);
        if (subject == null) {
            logger.finest("LAST_ACCESS_DENIED_PERMISSION=" + permission);
            this.phases.setLastAccessDeniedPermission(context, permission);
            logger.finest(" subject is null  logonProcess phase ");
            this.phases.logonProcess(context);
        } else if (this.authenticationFailed.implies(permission)) {
            logger.finest(" access authorized ");
            this.phases.authorize(context);
        } else if (this.logon.implies(permission)) {
            logger.finest(" logon phase ");
            this.phases.authorize(context);
        } else if (this.logonProcess.implies(permission)) {
            logger.finest(" logonProcess phase ");
            this.phases.logonProcess(context);
        } else if (this.logoff.implies(permission)) {
            logger.finest(" logoff phase ");
            this.phases.logoff(context);
            this.phases.authorize(context);
        } else if (this.registerProcess != null && this.register != null && this.registerProcess.implies(permission)) {
            logger.finest(" registerProcess phase ");
            boolean authenticate = this.phases.authenticate(context);
            if (!authenticate) {
                return;
            }
            boolean registerSucceed = this.phases.registrationProcess(context);
            if (!registerSucceed) {
                this.phases.registrationFailed(context);
            } else if (registerSucceed) {
                this.phases.redirectToLogon(context);
            }
        } else if (!this.phases.hasPermission(context, permission)) {
            this.phases.setLastAccessDeniedPermission(context, permission);
            logger.finest(" accessdenied phase ");
            this.phases.accessDenied(context);
        } else {
            logger.finest(" authorize phase ");
            this.phases.authorize(context);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

