/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import net.sf.jguard.ext.authentication.AuthenticationException;
import net.sf.jguard.ext.authentication.manager.AuthenticationManager;
import net.sf.jguard.ext.authentication.manager.AuthenticationManagerFactory;
import net.sf.jguard.ext.registration.SubjectTemplate;
import net.sf.jguard.ext.util.CryptUtils;
import net.sf.jguard.ext.util.XMLUtils;
import net.sf.jguard.jee.authentication.callbacks.HttpServletCallbackHandler;
import net.sf.jguard.jee.authentication.http.AnonymizerRequestWrapper;
import net.sf.jguard.jee.authentication.http.AuthSchemesHelper;
import net.sf.jguard.jee.authentication.http.HttpAuthenticationUtils;
import net.sf.jguard.jee.authentication.http.HttpConstants;
import net.sf.jguard.jee.authentication.http.JGuardServletRequestWrapper;
import net.sf.jguard.jee.authorization.http.HttpAccessControllerUtils;
import net.sf.jguard.jee.authorization.http.HttpPermissionFactory;
import net.sf.jguard.jee.authorization.http.PermissionFactory;
import net.sf.jguard.jee.util.WebappUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessFilterOld
implements Filter,
HttpConstants {
    public static final Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jguard$jee$authentication$http$AccessFilterOld == null ? (class$net$sf$jguard$jee$authentication$http$AccessFilterOld = AccessFilterOld.class$("net.sf.jguard.jee.authentication.http.AccessFilterOld")) : class$net$sf$jguard$jee$authentication$http$AccessFilterOld));
    private static String indexURI;
    private static URLPermission authenticationFailedURI;
    private static URLPermission logonURI;
    private static String logonURIStr;
    private static URLPermission logonProcessURI;
    private static Permissions logoffURIs;
    private static URLPermission registerProcessURI;
    private static String registerURI;
    private static String applicationName;
    private static String authScheme;
    private static boolean goToLastAccessDeniedUriOnSuccess;
    private PermissionFactory permissionFactory = null;
    private boolean local;
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$http$AccessFilterOld;

    public void init(FilterConfig filterCfg) throws ServletException {
        logger.debug("server info = " + filterCfg.getServletContext().getServerInfo());
        logger.debug("servletContextName=" + filterCfg.getServletContext().getServletContextName());
        logger.debug("servlet Real Path=" + WebappUtil.getWebappHomePath(filterCfg.getServletContext(), "/"));
        logger.debug("current Policy=" + Policy.getPolicy());
        ServletContext context = filterCfg.getServletContext();
        applicationName = context.getServletContextName();
        if (applicationName == null) {
            logger.error(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
            throw new ServletException(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
        }
        String filterConfigurationLocation = WebappUtil.getWebappHomePath(context, filterCfg.getInitParameter("configurationLocation"));
        Map filterSettings = this.loadFilterConfiguration(filterConfigurationLocation);
        this.setFilterSettings(filterSettings);
        context.setAttribute("applicationName", (Object)applicationName);
        context.setAttribute("authScheme", (Object)authScheme);
        context.setAttribute("sessionList", new ArrayList());
        String authenticationScope = (String)context.getAttribute("authenticationScope");
        this.local = !"jvm".equalsIgnoreCase(authenticationScope);
        this.permissionFactory = new HttpPermissionFactory();
    }

    private void setFilterSettings(Map filterSettings) throws ServletException {
        String tmpValue;
        indexURI = (String)filterSettings.get("indexURI");
        authenticationFailedURI = new URLPermission("authenticationFailedURI", (String)filterSettings.get("authenticationFailedURI"));
        logonProcessURI = new URLPermission("logonProcessURI", (String)filterSettings.get("logonProcessURI"));
        logonURIStr = (String)filterSettings.get("logonURI");
        logonURI = new URLPermission("logonURI", logonURIStr);
        logoffURIs = new Permissions();
        Iterator itLogoffURI = ((Set)filterSettings.get("logoffURIs")).iterator();
        while (itLogoffURI.hasNext()) {
            logoffURIs.add((Permission)new URLPermission("logoffURI", (String)itLogoffURI.next()));
        }
        registerProcessURI = new URLPermission("registerProcessURI", (String)filterSettings.get("registerProcessURI"));
        registerURI = (String)filterSettings.get("registerURI");
        authScheme = (String)filterSettings.get("authScheme");
        Collection authSchemes = AuthSchemesHelper.validateAuthScheme(authScheme);
        if (authSchemes.contains("FORM")) {
            HttpServletCallbackHandler.setLoginField((String)filterSettings.get("loginField"));
            HttpServletCallbackHandler.setPasswordField((String)filterSettings.get("passwordField"));
        }
        if ("false".equalsIgnoreCase(tmpValue = (String)filterSettings.get("goToLastAccessDeniedUriOnSuccess")) || "no".equalsIgnoreCase(tmpValue)) {
            goToLastAccessDeniedUriOnSuccess = false;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        URLPermission urlPermission = (URLPermission)this.permissionFactory.getPermission((ServletRequest)req);
        Subject subject = HttpAuthenticationUtils.getSubject(req.getSession(true));
        if (subject == null) {
            logger.debug("LAST_ACCESS_DENIED_URI=" + urlPermission.getURI());
            req.getSession(true).setAttribute("lastAccessDeniedURI", (Object)urlPermission.getURI());
            logger.debug(" subject is null  logonProcess phase ");
            this.logonProcess((HttpServletRequest)new AnonymizerRequestWrapper(req), res);
        } else if (authenticationFailedURI.implies((Permission)urlPermission)) {
            logger.debug(" access authorized ");
            chain.doFilter(request, response);
        } else if (logonURI.implies((Permission)urlPermission)) {
            logger.debug(" logon phase ");
            HttpServletCallbackHandler.buildFormChallenge(chain, (ServletRequest)req, (ServletResponse)res);
        } else if (logonProcessURI.implies((Permission)urlPermission)) {
            logger.debug(" logonProcess phase ");
            this.logonProcess(req, res);
        } else if (logoffURIs.implies((Permission)urlPermission)) {
            logger.debug(" logoff phase ");
            AccessFilterOld.logoff(req, res);
            chain.doFilter(request, response);
        } else if (registerProcessURI != null && registerURI != null && registerProcessURI.implies((Permission)urlPermission)) {
            logger.debug(" registerProcess phase ");
            boolean authenticate = this.authenticate((HttpServletRequest)new AnonymizerRequestWrapper(req), res);
            if (!authenticate) {
                return;
            }
            boolean registerSucceed = AccessFilterOld.registerProcess(req, res, chain);
            if (!registerSucceed) {
                logger.debug(" registration failed ", (Object)" registerProcess phase ");
                if (!res.isCommitted()) {
                    res.sendRedirect(res.encodeRedirectURL(req.getContextPath() + registerURI));
                } else {
                    logger.warn(" we cannot redirect to " + req.getContextPath() + registerURI + " because response is already commited ");
                }
            } else if (registerSucceed) {
                logger.debug(" registration succeed ", (Object)" registerProcess phase ");
                req.getSession(true).removeAttribute("authenticationUtils");
                req.getSession(true).removeAttribute("lastAccessDeniedURI");
                this.authenticateAfterRegistration(req, res);
            }
        } else if (!HttpAccessControllerUtils.hasPermission(req, (Permission)urlPermission)) {
            req.getSession(true).setAttribute("lastAccessDeniedURI", (Object)urlPermission.getURI());
            logger.debug(" accessdenied phase ");
            this.accessDenied(req, res);
        } else {
            logger.debug(" authorize phase ");
            this.authorize(chain, req, res);
        }
    }

    private static boolean registerProcess(HttpServletRequest req, HttpServletResponse res, FilterChain chain) {
        boolean success = false;
        AuthenticationManager auth = AuthenticationManagerFactory.getAuthenticationManager();
        SubjectTemplate st = null;
        try {
            st = AccessFilterOld.buildSubjectTemplate(req);
        }
        catch (AuthenticationException e1) {
            logger.error(" subject template cannot be built ", (Throwable)e1);
            success = false;
            return false;
        }
        String passwordField = HttpServletCallbackHandler.getPasswordField();
        Set credentials = st.getRequiredCredentials();
        Iterator itCreds = credentials.iterator();
        boolean found = false;
        JGuardCredential passwordCredential = null;
        while (itCreds.hasNext() && !found) {
            JGuardCredential cred = (JGuardCredential)itCreds.next();
            if (!cred.getId().equals(passwordField)) continue;
            passwordCredential = cred;
            found = true;
        }
        if (!found) {
            logger.warn("JGuardCredential matching  passwordField not found in the SubjectTemplate");
            success = false;
            return success;
        }
        char[] password = ((String)passwordCredential.getValue()).toCharArray();
        try {
            passwordCredential.setValue((Object)new String(CryptUtils.cryptPassword((char[])password)));
        }
        catch (NoSuchAlgorithmException ex) {
            logger.warn(ex.getMessage());
            success = false;
            return success;
        }
        Subject subject = null;
        try {
            subject = auth.createUser(st);
            success = true;
        }
        catch (AuthenticationException e) {
            StringBuffer sb7 = new StringBuffer(" registration failed ");
            logger.debug(" registrationProcess phase");
            success = false;
        }
        return success;
    }

    private static SubjectTemplate buildSubjectTemplate(HttpServletRequest req) throws AuthenticationException {
        AuthenticationManager auth = AuthenticationManagerFactory.getAuthenticationManager();
        SubjectTemplate defaultSt = auth.getDefaultSubjectTemplate();
        SubjectTemplate st = new SubjectTemplate();
        st.setName(defaultSt.getName());
        Set privateCredRequiredFromDefaultSt = defaultSt.getPrivateRequiredCredentials();
        Set privRequiredCred = AccessFilterOld.grabRegistrationForm(req, st, privateCredRequiredFromDefaultSt);
        st.setPrivateRequiredCredentials(privRequiredCred);
        Set publicCredRequiredFromDefaultSt = defaultSt.getPublicRequiredCredentials();
        Set pubRequiredCred = AccessFilterOld.grabRegistrationForm(req, st, publicCredRequiredFromDefaultSt);
        st.setPublicRequiredCredentials(pubRequiredCred);
        Set publicCredOptionalFromDefaultSt = defaultSt.getPublicOptionalCredentials();
        Set pubOptionalCred = AccessFilterOld.grabRegistrationForm(req, st, publicCredOptionalFromDefaultSt);
        st.setPublicOptionalCredentials(pubOptionalCred);
        Set privateCredOptionalFromDefaultSt = defaultSt.getPrivateOptionalCredentials();
        Set privOptionalCred = AccessFilterOld.grabRegistrationForm(req, st, privateCredOptionalFromDefaultSt);
        st.setPrivateOptionalCredentials(privOptionalCred);
        return st;
    }

    private static Set grabRegistrationForm(HttpServletRequest req, SubjectTemplate st, Set credentialsFromDefaultSt) {
        Iterator itCredentials = credentialsFromDefaultSt.iterator();
        HashSet<JGuardCredential> credSet = new HashSet<JGuardCredential>();
        while (itCredentials.hasNext()) {
            JGuardCredential jcredFromDefault = (JGuardCredential)itCredentials.next();
            if (req.getParameter(jcredFromDefault.getId()) == null) continue;
            JGuardCredential jcred = new JGuardCredential();
            jcred.setId(jcredFromDefault.getId());
            try {
                jcred.setValue((Object)req.getParameter(jcredFromDefault.getId()));
                credSet.add(jcred);
            }
            catch (IllegalArgumentException iae) {
                logger.warn(" the property " + jcredFromDefault.getId() + " doesn't exist in the HttpServletRequest ");
            }
        }
        return credSet;
    }

    private void logonProcess(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HttpSession session = req.getSession(true);
        Subject subject = HttpAuthenticationUtils.getSubject(session);
        if ("BASIC".equalsIgnoreCase(authScheme)) {
            String authorizationHeader = req.getHeader("Authorization");
            logger.debug("authorizationHeader=" + authorizationHeader);
            if (subject == null) {
                String AuthorizationHeaderValue = HttpServletCallbackHandler.buildBasicAuthHeader("guest", "guest", req.getCharacterEncoding());
                JGuardServletRequestWrapper jguardReq = new JGuardServletRequestWrapper(req);
                jguardReq.setHeader("Authorization", AuthorizationHeaderValue);
                logger.debug(" BASIC authentication subject is null  authenticate phase ");
                this.authenticate((HttpServletRequest)jguardReq, res);
            } else if (authorizationHeader == null || !authorizationHeader.startsWith("Basic ")) {
                logger.debug(" subject is not null but BASIC HEADER is incorrect " + authorizationHeader, (Object)" jGuard build BASIC challenge  ");
                HttpServletCallbackHandler.buildBasicChallenge(res, (String)session.getServletContext().getAttribute("applicationName"));
            } else {
                logger.debug(" BASIC AUTHENTICATION TYPE   authenticate phase  ");
                this.authenticate(req, res);
            }
        } else {
            logger.debug(" AUTHENTICATION TYPE =" + authScheme + "  authenticate phase  ");
            this.authenticate(req, res);
        }
    }

    private void accessDenied(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug(" access denied to " + req.getRequestURI());
        }
        logger.debug(" access is denied to " + req.getRequestURI() + " accessDeniedURI is not defined  jGuard send 401 http code ");
        res.setStatus(401);
        res.sendError(401, "access is denied to " + req.getRequestURI());
    }

    private void authorize(FilterChain chain, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        block7: {
            if (logger.isDebugEnabled()) {
                logger.debug("doFilter() -  access authorized to " + req.getRequestURI());
            }
            if (System.getSecurityManager() != null) {
                try {
                    AccessFilterOld.propagateSecurity((HttpServletRequest)new JGuardServletRequestWrapper(req), res, chain);
                }
                catch (PrivilegedActionException e) {
                    logger.warn(" access denied ", (Throwable)e);
                    if (!res.isCommitted()) {
                        res.sendError(401);
                    }
                    break block7;
                }
            }
            try {
                chain.doFilter((ServletRequest)new JGuardServletRequestWrapper(req), (ServletResponse)res);
            }
            catch (Throwable t) {
                logger.error(t.getMessage());
                res.sendError(503);
            }
        }
    }

    private static void logoff(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        HttpAuthenticationUtils auth = (HttpAuthenticationUtils)session.getAttribute("authenticationUtils");
        if (auth != null) {
            auth.logout();
            logger.debug(" user logoff ");
        }
        session.removeAttribute("authenticationUtils");
        if (logger.isDebugEnabled()) {
            logger.debug("doFilter() -  user logoff ");
        }
        try {
            session.invalidate();
        }
        catch (IllegalStateException ise) {
            logger.debug(" session is already invalidated ");
        }
    }

    private static void propagateSecurity(final HttpServletRequest request, final HttpServletResponse response, final FilterChain chain) throws PrivilegedActionException {
        HttpSession session = request.getSession();
        Subject subject = HttpAuthenticationUtils.getSubject(session);
        Subject.doAsPrivileged(subject, new PrivilegedExceptionAction(){

            public Object run() throws IOException, ServletException {
                try {
                    chain.doFilter((ServletRequest)new JGuardServletRequestWrapper(request), (ServletResponse)response);
                }
                catch (Throwable t) {
                    logger.error(t.getMessage());
                    response.sendError(503);
                }
                return null;
            }
        }, null);
    }

    private boolean authenticate(HttpServletRequest req, HttpServletResponse res) throws IOException {
        boolean authenticationFailed = !HttpAuthenticationUtils.authenticate(req, res, false, this.local);
        return this.postAuthenticationProcess(req, res, authenticationFailed);
    }

    private boolean authenticateAfterRegistration(HttpServletRequest req, HttpServletResponse res) throws IOException {
        boolean authenticationFailed = !HttpAuthenticationUtils.authenticate(req, res, true, this.local);
        return this.postAuthenticationProcess(req, res, authenticationFailed);
    }

    private boolean postAuthenticationProcess(HttpServletRequest req, HttpServletResponse res, boolean authenticationFailed) throws IOException {
        Subject subject = HttpAuthenticationUtils.getSubject(req.getSession(true));
        if (authenticationFailed) {
            if (res.isCommitted()) {
                logger.warn(" response is already committed ");
            }
            if ("BASIC".equalsIgnoreCase(authScheme)) {
                HttpServletCallbackHandler.buildBasicChallenge(res, (String)req.getSession(true).getServletContext().getAttribute("applicationName"));
                return !authenticationFailed;
            }
            logger.debug("authentication failed redirect to " + authenticationFailedURI.getURI());
            if (authenticationFailedURI != null && !authenticationFailedURI.getURI().equals("")) {
                res.sendRedirect(res.encodeRedirectURL(req.getContextPath() + authenticationFailedURI.getURI()));
                logger.debug(" NOT BASIC AUTHENTICATION - user is not authenticated  redirect to " + req.getContextPath() + authenticationFailedURI.getURI());
            } else {
                this.accessDenied(req, res);
            }
        } else {
            HttpSession oldSession = req.getSession(true);
            String redirectURI = indexURI;
            String lastAccessDeniedURI = (String)oldSession.getAttribute("lastAccessDeniedURI");
            HttpAuthenticationUtils httpAuthenticationUtils = HttpAuthenticationUtils.getHttpAuthenticationUtils(req, this.local);
            subject = httpAuthenticationUtils.getSubject();
            if (!res.isCommitted()) {
                oldSession.removeAttribute("authenticationUtils");
                oldSession.invalidate();
                HttpSession newSession = req.getSession(true);
                newSession.setAttribute("authenticationUtils", (Object)httpAuthenticationUtils);
            }
            if (lastAccessDeniedURI != null && lastAccessDeniedURI != "") {
                if (goToLastAccessDeniedUriOnSuccess) {
                    redirectURI = lastAccessDeniedURI;
                } else {
                    URLPermission urlPermission = new URLPermission("indexURI", indexURI);
                    if (!HttpAccessControllerUtils.hasPermission(req, (Permission)urlPermission)) {
                        redirectURI = logonURIStr;
                    }
                }
            }
            logger.debug(" user is authenticated ", (Object)(" redirect to " + redirectURI));
            if (!res.isCommitted()) {
                res.sendRedirect(res.encodeRedirectURL(req.getContextPath() + redirectURI));
            }
        }
        return !authenticationFailed;
    }

    public void destroy() {
    }

    private Map loadFilterConfiguration(String configurationLocation) {
        Element goToLastAccessDeniedUriOnSuccessElement;
        Element passwordElement;
        Document doc = XMLUtils.read((String)configurationLocation);
        Element authentication = doc.getRootElement().element("filter");
        HashMap<String, Object> filterSettings = new HashMap<String, Object>();
        filterSettings.put("indexURI", authentication.element("indexURI").getTextTrim());
        filterSettings.put("authenticationFailedURI", authentication.element("authenticationFailedURI").getTextTrim());
        if (authentication.element("registerProcessURI") != null) {
            filterSettings.put("registerProcessURI", authentication.element("registerProcessURI").getTextTrim());
        }
        if (authentication.element("registerURI") != null) {
            filterSettings.put("registerURI", authentication.element("registerURI").getTextTrim());
        }
        filterSettings.put("logonProcessURI", authentication.element("logonProcessURI").getTextTrim());
        filterSettings.put("logonURI", authentication.element("logonURI").getTextTrim());
        HashSet<String> logoffURIsCollection = new HashSet<String>();
        Iterator itLogoffURI = authentication.element("logoffURIs").elements("logoffURI").iterator();
        while (itLogoffURI.hasNext()) {
            logoffURIsCollection.add(((Element)itLogoffURI.next()).getTextTrim());
        }
        filterSettings.put("logoffURIs", logoffURIsCollection);
        filterSettings.put("authScheme", authentication.element("authScheme").getTextTrim());
        Element loginElement = authentication.element("loginField");
        if (loginElement != null) {
            filterSettings.put("loginField", loginElement.getTextTrim());
        }
        if ((passwordElement = authentication.element("passwordField")) != null) {
            filterSettings.put("passwordField", passwordElement.getTextTrim());
        }
        if ((goToLastAccessDeniedUriOnSuccessElement = authentication.element("goToLastAccessDeniedUriOnSuccess")) != null) {
            filterSettings.put("goToLastAccessDeniedUriOnSuccess", goToLastAccessDeniedUriOnSuccessElement.getTextTrim());
        }
        return filterSettings;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        goToLastAccessDeniedUriOnSuccess = true;
    }
}

