/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.io.IOException;
import java.security.Policy;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.jguard.core.PolicyEnforcementPoint;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.AuthenticationBindings;
import net.sf.jguard.core.authorization.AuthorizationBindings;
import net.sf.jguard.core.authorization.PolicyDecisionPoint;
import net.sf.jguard.jee.util.WebappUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jguard$jee$authentication$http$AccessFilter == null ? (class$net$sf$jguard$jee$authentication$http$AccessFilter = AccessFilter.class$("net.sf.jguard.jee.authentication.http.AccessFilter")) : class$net$sf$jguard$jee$authentication$http$AccessFilter));
    public static final String SERVLET_REQUEST = "servletRequest";
    public static final String SERVLET_RESPONSE = "servletResponse";
    public static final String FILTER_CHAIN = "filterChain";
    private static String applicationName;
    private PolicyEnforcementPoint pep = null;
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$http$AccessFilter;
    static /* synthetic */ Class class$net$sf$jguard$jee$authorization$http$HttpServletAuthorizationBindings;
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings;

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.debug("server info = " + filterConfig.getServletContext().getServerInfo());
        logger.debug("servletContextName=" + filterConfig.getServletContext().getServletContextName());
        logger.debug("servlet Real Path=" + WebappUtil.getWebappHomePath(filterConfig.getServletContext(), "/"));
        logger.debug("current Policy=" + Policy.getPolicy());
        ServletContext context = filterConfig.getServletContext();
        applicationName = context.getServletContextName();
        if (applicationName == null) {
            logger.error(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
            throw new ServletException(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
        }
        AuthenticationBindings authenticationBindings = this.initAuthenticationBindings(filterConfig, context);
        PolicyDecisionPoint pdp = this.initPolicyDecisionPoint(filterConfig);
        this.pep = new PolicyEnforcementPoint(authenticationBindings, pdp);
    }

    private PolicyDecisionPoint initPolicyDecisionPoint(FilterConfig filterConfig) throws ServletException {
        String authorizationBindingsImpl = filterConfig.getInitParameter("authorizationBindings");
        if (authorizationBindingsImpl == null || authorizationBindingsImpl.equals("")) {
            authorizationBindingsImpl = (class$net$sf$jguard$jee$authorization$http$HttpServletAuthorizationBindings == null ? (class$net$sf$jguard$jee$authorization$http$HttpServletAuthorizationBindings = AccessFilter.class$("net.sf.jguard.jee.authorization.http.HttpServletAuthorizationBindings")) : class$net$sf$jguard$jee$authorization$http$HttpServletAuthorizationBindings).getName();
        }
        AuthorizationBindings authorizationBindings = null;
        try {
            authorizationBindings = (AuthorizationBindings)Thread.currentThread().getContextClassLoader().loadClass(authorizationBindingsImpl).newInstance();
        }
        catch (InstantiationException iex) {
            throw new ServletException(iex.getMessage());
        }
        catch (ClassNotFoundException cne) {
            throw new ServletException(cne.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new ServletException(iae.getMessage());
        }
        PolicyDecisionPoint policyDecisionPoint = new PolicyDecisionPoint(authorizationBindings);
        return policyDecisionPoint;
    }

    private AuthenticationBindings initAuthenticationBindings(FilterConfig filterConfig, ServletContext context) throws ServletException {
        String authenticationBindingsImpl = filterConfig.getInitParameter("authenticationBindings");
        if (authenticationBindingsImpl == null || authenticationBindingsImpl.equals("")) {
            authenticationBindingsImpl = (class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings == null ? (class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings = AccessFilter.class$("net.sf.jguard.jee.authentication.http.HttpServletAuthenticationBindings")) : class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings).getName();
        }
        String filterConfigurationLocation = WebappUtil.getWebappHomePath(context, filterConfig.getInitParameter("configurationLocation"));
        AuthenticationBindings authenticationBindings = null;
        try {
            authenticationBindings = (AuthenticationBindings)Thread.currentThread().getContextClassLoader().loadClass(authenticationBindingsImpl).newInstance();
            String authenticationScope = (String)context.getAttribute("authenticationScope");
            authenticationBindings.init(filterConfigurationLocation, authenticationScope);
            authenticationBindings.addAlwaysGrantedPermissionsToPolicy();
        }
        catch (InstantiationException iex) {
            throw new ServletException(iex.getMessage());
        }
        catch (ClassNotFoundException cne) {
            throw new ServletException(cne.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new ServletException(iae.getMessage());
        }
        return authenticationBindings;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        AccessContext context = new AccessContext();
        context.putParameter(SERVLET_REQUEST, (Object)servletRequest);
        context.putParameter(SERVLET_RESPONSE, (Object)servletResponse);
        context.putParameter(FILTER_CHAIN, (Object)filterChain);
        this.pep.process(context);
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

