/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.jee.taglib;

import java.io.IOException;

import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

import net.sf.jguard.ext.SecurityConstants;
import net.sf.jguard.jee.authentication.http.HttpAuthenticationUtils;
import net.sf.jguard.jee.authentication.http.HttpConstants;

public class TagUtils {

	
	/**
	 * grab the Subject from the user's session and authenticate
	 * it if Subject is null.
	 * @param pageContext
	 * @return subject
	 * @throws JspTagException
	 */
	protected static Subject getSubject(PageContext pageContext) throws JspTagException {
		HttpSession session = pageContext.getSession();
		HttpAuthenticationUtils httpUtils = (HttpAuthenticationUtils)session.getAttribute(HttpConstants.AUTHN_UTILS);
		Subject subject = null;
		if(httpUtils!=null){
			subject = httpUtils.getSubject();
		}

		boolean local = true;
		String authenticationScope = (String)pageContext.getServletContext().getAttribute(SecurityConstants.AUTHENTICATION_SCOPE);
	    if(SecurityConstants.JVM_SCOPE.equalsIgnoreCase(authenticationScope)){
	    	local = false;
	    }
	    if(subject==null ||session.getAttribute(HttpConstants.AUTHN_UTILS)==null){
	        try {
				HttpAuthenticationUtils.authenticate((HttpServletRequest)pageContext.getRequest(),(HttpServletResponse)pageContext.getResponse(),false,local);
				//we grab the subject authenticated
				subject = ((HttpAuthenticationUtils)session.getAttribute(HttpConstants.AUTHN_UTILS)).getSubject();
			} catch (IOException e) {
				throw new JspTagException(e.getMessage());
			}
	    }
		return subject;
	}

}
