 /*
  jGuard is a security framework based on top of jaas (java authentication and authorization security).
  it is written for web applications, to resolve simply, access control problems.
  version $Name$
  http://sourceforge.net/projects/jguard/
 
  Copyright (C) 2004  Charles GAY
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
 
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
 
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
 
  jGuard project home page:
  http://sourceforge.net/projects/jguard/
 
  */
 package net.sf.jguard.jee.taglib;
 
 import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

import javax.security.auth.Subject;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.jee.authentication.http.HttpConstants;

import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
 
 /**
  * display the Public Credential of the Subject.
  *
  * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
  *
  */
 public class PubCredential extends TagSupport implements HttpConstants {
 	/** Logger for this class */
 	private static final Logger logger = LoggerFactory.getLogger(PubCredential.class);
 	/**
 	 * serial version id.
 	 */
 	private static final long serialVersionUID = 3257570611415888950L;
 	private String id;
 	private String def = "";
 
 	/**
 	 * @return id
 	 */
 	public String getId() {
 		return id;
 	}
 
 	/**
 	 * @param id
 	 */
 	public void setId(String id) {
 		this.id = id;
 	}
 
 	public int doEndTag() throws JspException {
 		String value = null;
 		String defaut = (String) ExpressionEvaluatorManager.evaluate("default", def, String.class, this, pageContext);
 		String name = (String) ExpressionEvaluatorManager.evaluate("id", id, String.class, this, pageContext);
 
 		Subject subject = TagUtils.getSubject(pageContext);
 
 		if (subject != null) {
 			Set publicCredentials = subject.getPublicCredentials();
 			Iterator it = publicCredentials.iterator();
 			JGuardCredential cred = null;
 
 			while (it.hasNext()) {
 				cred = (JGuardCredential) it.next();
 				// if the id wanted by the webapp developer
 				// is encountered in the public credentials subject
 				if (cred.getId().equals(name)) {
 					value = (String) cred.getValue();
 					break;
 				}
 			}
 		}
 
 		if (value == null && defaut != null) {
 			value = defaut;
 		} else if (name == null) {
 			value = "";
 		}
 
 		if (logger.isDebugEnabled()) {
 			logger.debug("<jguard:PubCredential> id=" + this.id);
 			logger.debug("<jguard:PubCredential> default=" + defaut);
 			logger.debug("<jguard:PubCredential> value=" + value);
 		}
 		try {
 			// output the value
 			pageContext.getOut().print(value);
 		} catch (IOException e) {
 			logger.error("doEndTag()", e);
 		}
 
 		return EVAL_PAGE;
 	}
 
 	/**
 	 * @return Returns the def.
 	 */
 	public String getDefault() {
 		return def;
 	}
 
 	/**
 	 * @param def
 	 *            The def to set.
 	 */
 	public void setDefault(String def) {
 		this.def = def;
 	}
 }
