/*
 * URLPermissionFactory.java
 *
 * Created on 2 mars 2007, 21:41
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package net.sf.jguard.jee.authorization.http;

import java.security.Permission;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;

import javax.servlet.http.HttpServletRequest;

import net.sf.jguard.core.authorization.permissions.URLPermission;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * return an URLPermission.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public class HttpPermissionFactory implements PermissionFactory{
   
    static public final Logger logger = LoggerFactory.getLogger(HttpPermissionFactory.class);
    private static Pattern starPattern = Pattern.compile(HttpPermissionFactory.STAR);
    private static final String STAR = "\\*";
    private static final String DOUBLE_STAR = "\\*\\*";
    
    
    /** Creates a new instance of URLPermissionFactory */
    public HttpPermissionFactory() {
    }

   public Permission getPermission(ServletRequest req){
            HttpServletRequest request = (HttpServletRequest)req;
            String uriWithQuery = buildRequest(request);
	    logger.debug("uriWithQuery="+uriWithQuery);
            //build the permission corresponding to the URI and prevent any '*' character to be interpreted as a regexp
            StringBuffer actions = new StringBuffer(URLPermission.removeRegexpFromURI(uriWithQuery));
            actions.append(',').append(request.getProtocol()).append(',').append(request.getMethod()).append("permission build from the user request");
            URLPermission urlPermission = new URLPermission("permissionFromUser",actions.toString());
            return urlPermission;
   }
   
   private static String buildRequest(HttpServletRequest req) {
	
       String uriWithQuery = null;
       
       String uri = req.getRequestURI();
       String servletPath = req.getServletPath();
       StringBuffer sb =new StringBuffer(uri.substring(uri.indexOf(servletPath)));
        
        if(req.getQueryString()!=null && req.getQueryString().length()>0){
            sb.append("?");
            sb.append(req.getQueryString());
        }
        uriWithQuery = sb.toString();
        Matcher matcher = starPattern.matcher(uriWithQuery);
        uriWithQuery = matcher.replaceAll(HttpPermissionFactory.DOUBLE_STAR);
        logger.debug("uriWithQuery="+uriWithQuery);
		return uriWithQuery;
	}
}

