/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.jee.authentication.http;

import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import net.sf.jguard.core.CoreConstants;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.principals.RolePrincipal;
import net.sf.jguard.core.principals.UserPrincipal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
/**
 * wrap the ServletRequest object to 'decorate' it to
 * respect the JAAS mechanism present in j2se.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 *
 */
public class JGuardServletRequestWrapper extends HttpServletRequestWrapper  {
    private static final String LOGIN = "login";
	private static Logger logger = LoggerFactory.getLogger(JGuardServletRequestWrapper.class);
    private Map headers = null;
	private HttpServletRequest request;
	
	public JGuardServletRequestWrapper(HttpServletRequest req) {
		super(req);
		this.request = req;
		headers = new HashMap();
	}

	/**
	 * wrap the isUserInRole method to check against
	 * all the {@link RolePrincipal}'s set of the Subject object.
	 * @param role : name of the principal(role) we are looking for
	 * @return boolean :return 'true' if one of the principal the Subject
	 * owns has got the same name.return 'false' otherwise.
	 */
    public boolean isUserInRole(String role){
    	String applicationName = (String) request.getSession(true).getServletContext().getAttribute(CoreConstants.APPLICATION_NAME);
    	role = RolePrincipal.getName(role, applicationName);
    	Subject subject = ((HttpAuthenticationUtils)request.getSession().getAttribute(HttpConstants.AUTHN_UTILS)).getSubject();
    	Set principals = subject.getPrincipals(RolePrincipal.class);
    	Iterator itPrincipals = principals.iterator();
    	while(itPrincipals.hasNext()){
    		Principal principal = (Principal)itPrincipals.next();
    		if(role.equals(principal.getName())){
    			return true;
    		}
    	}
    	return false;

    }

    /**
     * return a SubjectAsPrincipal object which wrap the Subject
     * in a Principal.
     * @return principal
     */
    public Principal getUserPrincipal(){
    	Subject subject =  ((HttpAuthenticationUtils)request.getSession().getAttribute(HttpConstants.AUTHN_UTILS)).getSubject();
    	return new UserPrincipal(subject);
    }

    /**
     *
     * @return remote user login credential String value
     */
    public String getRemoteUser(){
    	Subject subject = ((HttpAuthenticationUtils)request.getSession().getAttribute(HttpConstants.AUTHN_UTILS)).getSubject();
    	Set publicCredentials = subject.getPublicCredentials();
    	Iterator it = publicCredentials.iterator();
    	while(it.hasNext()){
    		JGuardCredential cred = (JGuardCredential)it.next();
    		if(cred.getId().equalsIgnoreCase(JGuardServletRequestWrapper.LOGIN)){
    			return (String)cred.getValue();
    		}
    	}
    	try{
	    	Set privateCredentials = subject.getPrivateCredentials();
	    	Iterator it2 = privateCredentials.iterator();
	    	while(it2.hasNext()){
	    		JGuardCredential cred2 = (JGuardCredential)it2.next();
	    		if(cred2.getId().equalsIgnoreCase(JGuardServletRequestWrapper.LOGIN)){
	    			return (String)cred2.getValue();
	    		}
	    	}
    	}catch(SecurityException sex){
    		logger.debug(" you don't have the permission to look into the private Credentials of the user ",sex);
    	}
    	return null;
    }

	public void setHeader(String headerName,String headerValue){
			headers.put(headerName, headerValue);
	}
	
	public String getHeader(String headerName){
		
		if(headers.containsKey(headerName)){
			return (String)headers.get(headerName);
		}else{
			return super.getHeader(headerName);
		}
	}
}
