/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/

package net.sf.jguard.jee.authentication.http;

import java.io.IOException;
import java.security.Policy;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import net.sf.jguard.core.PolicyEnforcementPoint;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.AuthenticationBindings;
import net.sf.jguard.core.authorization.AuthorizationBindings;
import net.sf.jguard.core.authorization.PolicyDecisionPoint;
import net.sf.jguard.ext.SecurityConstants;
import net.sf.jguard.jee.authorization.http.HttpServletAuthorizationBindings;
import net.sf.jguard.jee.util.WebappUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Bound HTTP call (contained into AccessContext) to AuthenticationLifeCycle via 
 * via AuthenticationBindings.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public class AccessFilter implements Filter{
    private static final Logger logger = LoggerFactory.getLogger(AccessFilter.class);
    public final static String SERVLET_REQUEST="servletRequest";
    public final static String SERVLET_RESPONSE="servletResponse";
    public final static String FILTER_CHAIN="filterChain";
    //unique name of the application
    private static String applicationName;
    private PolicyEnforcementPoint pep = null; 
    
    
    /**
     * Creates a new instance of HttpServletAuthenticationFilter
     */
    public AccessFilter() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.debug("server info = "+filterConfig.getServletContext().getServerInfo());
    	logger.debug("servletContextName="+ filterConfig.getServletContext().getServletContextName());
    	logger.debug("servlet Real Path="+ WebappUtil.getWebappHomePath(filterConfig.getServletContext(),"/"));
    	logger.debug("current Policy="+Policy.getPolicy());
        ServletContext context = filterConfig.getServletContext();
    	applicationName = context.getServletContextName();
    	if(applicationName == null){
    		logger.error(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
    		throw new ServletException(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
    	}
    	AuthenticationBindings authenticationBindings = initAuthenticationBindings(filterConfig, context);
        PolicyDecisionPoint pdp = initPolicyDecisionPoint(filterConfig);
        pep = new PolicyEnforcementPoint(authenticationBindings,pdp);
    }

	private PolicyDecisionPoint initPolicyDecisionPoint(FilterConfig filterConfig)
			throws ServletException {
		   String authorizationBindingsImpl = filterConfig.getInitParameter(HttpConstants.AUTHORIZATION_BINDINGS);
		   if(authorizationBindingsImpl == null ||authorizationBindingsImpl.equals("")){
			   authorizationBindingsImpl = HttpServletAuthorizationBindings.class.getName();
			}
		   AuthorizationBindings authorizationBindings = null;
		   try {
			   authorizationBindings = (AuthorizationBindings) Thread.currentThread().getContextClassLoader().loadClass(authorizationBindingsImpl).newInstance();
		       
		   } catch(InstantiationException iex) {
		       throw new ServletException(iex.getMessage());
		   } catch (ClassNotFoundException cne){
		       throw new ServletException(cne.getMessage());
		   }catch(IllegalAccessException iae){
		       throw new ServletException(iae.getMessage());
		   }
		  
		   PolicyDecisionPoint policyDecisionPoint = new PolicyDecisionPoint(authorizationBindings);
		   return policyDecisionPoint;
	}

	private AuthenticationBindings initAuthenticationBindings(FilterConfig filterConfig,
			ServletContext context) throws ServletException {
		String authenticationBindingsImpl = filterConfig.getInitParameter(HttpConstants.AUTHENTICATION_BINDINGS);
		if(authenticationBindingsImpl == null ||authenticationBindingsImpl.equals("")){
			authenticationBindingsImpl = HttpServletAuthenticationBindings.class.getName();
		}
        String filterConfigurationLocation = WebappUtil.getWebappHomePath(context,filterConfig.getInitParameter(HttpConstants.CONFIGURATION_LOCATION));
        AuthenticationBindings authenticationBindings = null;
        try {
            authenticationBindings = (AuthenticationBindings) Thread.currentThread().getContextClassLoader().loadClass(authenticationBindingsImpl).newInstance();
            String authenticationScope = (String)context.getAttribute(SecurityConstants.AUTHENTICATION_SCOPE);
            authenticationBindings.init(filterConfigurationLocation,authenticationScope);
            authenticationBindings.addAlwaysGrantedPermissionsToPolicy();
        } catch(InstantiationException iex) {
            throw new ServletException(iex.getMessage());
        } catch (ClassNotFoundException cne){
            throw new ServletException(cne.getMessage());
        }catch(IllegalAccessException iae){
            throw new ServletException(iae.getMessage());
        }
       
        return authenticationBindings;
	}

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        AccessContext context = new AccessContext();
        context.putParameter(SERVLET_REQUEST,servletRequest);
        context.putParameter(SERVLET_RESPONSE,servletResponse);
        context.putParameter(FILTER_CHAIN,filterChain);
        //chain.doFilter is embedded in the pep.process method
        pep.process(context);
       
    }

    public void destroy() {
    }
    
}
