/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.provisioning;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Permissions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.AuthenticationException;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.core.authentication.manager.AuthenticationManagerFactory;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import net.sf.jguard.core.provisioning.ProvisioningServicePoint;
import net.sf.jguard.core.provisioning.SubjectTemplate;
import net.sf.jguard.ext.util.CryptUtils;
import net.sf.jguard.ext.util.XMLUtils;
import net.sf.jguard.jee.authentication.callbacks.HttpServletCallbackHandler;
import net.sf.jguard.jee.authentication.http.AnonymizerRequestWrapper;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletProvisioningServicePoint
implements ProvisioningServicePoint {
    private static final Logger logger = LoggerFactory.getLogger((String)(class$net$sf$jguard$jee$provisioning$HttpServletProvisioningServicePoint == null ? (class$net$sf$jguard$jee$provisioning$HttpServletProvisioningServicePoint = HttpServletProvisioningServicePoint.class$("net.sf.jguard.jee.provisioning.HttpServletProvisioningServicePoint")) : class$net$sf$jguard$jee$provisioning$HttpServletProvisioningServicePoint).getName());
    private String registerURI;
    private URLPermission registerProcessPermission;
    private URLPermission registerPermission;
    static /* synthetic */ Class class$net$sf$jguard$jee$provisioning$HttpServletProvisioningServicePoint;

    public void init(String location) {
        Map settings = this.loadFilterConfiguration(location);
        this.setSettings(settings);
    }

    public Permission getRegisterPermission() {
        return this.registerPermission;
    }

    public Permission getRegisterProcessPermission() {
        return this.registerProcessPermission;
    }

    public boolean registerProcess(AccessContext context) {
        boolean registerSucceed = this.registerCoreProcess(context);
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getAttribute("servletResponse");
        boolean result = false;
        if (!registerSucceed) {
            logger.debug(" registration failed ", (Object)" registerProcess phase ");
            if (!response.isCommitted()) {
                try {
                    response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + this.registerURI));
                }
                catch (IOException e) {
                    logger.warn(" we cannot redirect to " + request.getContextPath() + this.registerURI + " because " + e.getMessage());
                }
            } else {
                logger.warn(" we cannot redirect to " + request.getContextPath() + this.registerURI + " because response is already commited ");
            }
            result = false;
        } else if (registerSucceed) {
            logger.debug(" registration succeed ", (Object)" registerProcess phase ");
            request.getSession(true).removeAttribute("authenticationUtils");
            request.getSession(true).removeAttribute("lastAccessDeniedPermission");
            result = true;
        }
        return result;
    }

    public boolean registerCoreProcess(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        boolean success = false;
        AuthenticationManager auth = AuthenticationManagerFactory.getAuthenticationManager();
        SubjectTemplate st = null;
        try {
            st = HttpServletProvisioningServicePoint.buildSubjectTemplate(request);
        }
        catch (AuthenticationException e1) {
            logger.error(" subject template cannot be built ", (Throwable)e1);
            success = false;
            return false;
        }
        String passwordField = HttpServletCallbackHandler.getPasswordField();
        Set credentials = st.getRequiredCredentials();
        Iterator itCreds = credentials.iterator();
        boolean found = false;
        JGuardCredential passwordCredential = null;
        while (itCreds.hasNext() && !found) {
            JGuardCredential cred = (JGuardCredential)itCreds.next();
            if (!cred.getName().equals(passwordField)) continue;
            passwordCredential = cred;
            found = true;
        }
        if (!found) {
            logger.warn("JGuardCredential matching  passwordField not found in the SubjectTemplate");
            success = false;
            return success;
        }
        char[] password = passwordCredential.getValue().toString().toCharArray();
        try {
            passwordCredential.setValue((Object)new String(CryptUtils.cryptPassword((char[])password)));
        }
        catch (NoSuchAlgorithmException ex) {
            logger.warn(ex.getMessage());
            success = false;
            return success;
        }
        try {
            auth.createUser(st, auth.getDefaultOrganization());
            success = true;
        }
        catch (AuthenticationException e) {
            logger.debug(" registrationProcess failed ");
            success = false;
        }
        return success;
    }

    public AccessContext anonymize(AccessContext context) {
        AccessContext accContext = (AccessContext)context.clone();
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        accContext.setAttribute("servletRequest", (Object)new AnonymizerRequestWrapper(request));
        return accContext;
    }

    private static SubjectTemplate buildSubjectTemplate(HttpServletRequest req) throws AuthenticationException {
        AuthenticationManager auth = AuthenticationManagerFactory.getAuthenticationManager();
        SubjectTemplate defaultSt = auth.getDefaultOrganization().getSubjectTemplate();
        SubjectTemplate st = new SubjectTemplate();
        Set privateCredRequiredFromDefaultSt = defaultSt.getPrivateRequiredCredentials();
        Set privRequiredCred = HttpServletProvisioningServicePoint.grabRegistrationForm(req, st, privateCredRequiredFromDefaultSt);
        st.setPrivateRequiredCredentials(privRequiredCred);
        Set publicCredRequiredFromDefaultSt = defaultSt.getPublicRequiredCredentials();
        Set pubRequiredCred = HttpServletProvisioningServicePoint.grabRegistrationForm(req, st, publicCredRequiredFromDefaultSt);
        st.setPublicRequiredCredentials(pubRequiredCred);
        Set publicCredOptionalFromDefaultSt = defaultSt.getPublicOptionalCredentials();
        Set pubOptionalCred = HttpServletProvisioningServicePoint.grabRegistrationForm(req, st, publicCredOptionalFromDefaultSt);
        st.setPublicOptionalCredentials(pubOptionalCred);
        Set privateCredOptionalFromDefaultSt = defaultSt.getPrivateOptionalCredentials();
        Set privOptionalCred = HttpServletProvisioningServicePoint.grabRegistrationForm(req, st, privateCredOptionalFromDefaultSt);
        st.setPrivateOptionalCredentials(privOptionalCred);
        return st;
    }

    private static Set grabRegistrationForm(HttpServletRequest req, SubjectTemplate st, Set credentialsFromDefaultSt) {
        Iterator itCredentials = credentialsFromDefaultSt.iterator();
        HashSet<JGuardCredential> credSet = new HashSet<JGuardCredential>();
        while (itCredentials.hasNext()) {
            JGuardCredential jcredFromDefault = (JGuardCredential)itCredentials.next();
            if (req.getParameter(jcredFromDefault.getName()) == null) continue;
            JGuardCredential jcred = new JGuardCredential();
            jcred.setName(jcredFromDefault.getName());
            try {
                jcred.setValue((Object)req.getParameter(jcredFromDefault.getName()));
                credSet.add(jcred);
            }
            catch (IllegalArgumentException iae) {
                logger.warn(" the property " + jcredFromDefault.getName() + " doesn't exist in the HttpServletRequest ");
            }
        }
        return credSet;
    }

    private Map loadFilterConfiguration(String configurationLocation) {
        Element passwordElement;
        Document doc = XMLUtils.read((String)configurationLocation);
        Element authentication = doc.getRootElement();
        HashMap<String, String> filterSettings = new HashMap<String, String>();
        if (authentication.element("registerProcessURI") != null) {
            filterSettings.put("registerProcessURI", authentication.element("registerProcessURI").getTextTrim());
        }
        if (authentication.element("registerURI") != null) {
            filterSettings.put("registerURI", authentication.element("registerURI").getTextTrim());
        }
        filterSettings.put("authScheme", authentication.element("authScheme").getTextTrim());
        Element loginElement = authentication.element("loginField");
        if (loginElement != null) {
            filterSettings.put("loginField", loginElement.getTextTrim());
        }
        if ((passwordElement = authentication.element("passwordField")) != null) {
            filterSettings.put("passwordField", passwordElement.getTextTrim());
        }
        return filterSettings;
    }

    private void setSettings(Map settings) {
        this.registerProcessPermission = new URLPermission("registerProcessURI", (String)settings.get("registerProcessURI"));
        this.registerURI = (String)settings.get("registerURI");
        this.registerPermission = new URLPermission("registerURI", this.registerURI);
    }

    public Permissions getGrantedPermissions() {
        Permissions alwaysGrantedPermissions = new Permissions();
        alwaysGrantedPermissions.add(this.getRegisterPermission());
        alwaysGrantedPermissions.add(this.getRegisterProcessPermission());
        return alwaysGrantedPermissions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

