/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.listeners;

import java.security.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.Configuration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.sf.jguard.core.authentication.configuration.JGuardConfiguration;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.core.authorization.manager.PermissionProvider;
import net.sf.jguard.core.authorization.policy.AccessControllerUtils;
import net.sf.jguard.core.authorization.policy.MultipleAppPolicy;
import net.sf.jguard.core.authorization.policy.PolicyHelper;
import net.sf.jguard.ext.authentication.manager.AuthenticationHelper;
import net.sf.jguard.ext.authorization.AuthorizationHelper;
import net.sf.jguard.ext.authorization.manager.AuthorizationManager;
import net.sf.jguard.ext.java5.authentication.jmx.JMXHelper;
import net.sf.jguard.jee.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jguard$jee$listeners$ContextListener == null ? (class$net$sf$jguard$jee$listeners$ContextListener = ContextListener.class$("net.sf.jguard.jee.listeners.ContextListener")) : class$net$sf$jguard$jee$listeners$ContextListener));
    static /* synthetic */ Class class$net$sf$jguard$jee$listeners$ContextListener;

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        logger.debug(" context destroyed ");
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (Policy.getPolicy() instanceof MultipleAppPolicy) {
            MultipleAppPolicy policy = (MultipleAppPolicy)Policy.getPolicy();
            policy.unregisterPermissionProvider((Object)contextClassLoader);
        }
        servletContextEvent.getServletContext().removeAttribute("captchaService");
        servletContextEvent.getServletContext().removeAttribute("sessionList");
    }

    public void contextInitialized(ServletContextEvent contextEvent) {
        logger.debug("#####  initializing ContextListener ... #####");
        ServletContext context = contextEvent.getServletContext();
        context.setAttribute("sessionList", new ArrayList());
        String webappHomePath = ContextUtil.getContextPath(context, "/");
        if (!webappHomePath.endsWith("/")) {
            webappHomePath = webappHomePath + "/";
        }
        String applicationName = context.getServletContextName();
        context.setAttribute("applicationName", (Object)applicationName);
        this.initAuthentication(context, webappHomePath, applicationName);
        Configuration configuration = (Configuration)context.getAttribute("jGuardConfiguration");
        AccessControllerUtils authUtils = this.initAuthorization(context, webappHomePath, applicationName);
        String enableJMX = context.getInitParameter("enableJMX");
        if (enableJMX != null && "true".equalsIgnoreCase(enableJMX)) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("mbeanServerForConnector", context.getInitParameter("mbeanServerForConnector"));
            options.put("rmiRegistryHost", context.getInitParameter("rmiRegistryHost"));
            options.put("rmiRegistryPort", context.getInitParameter("rmiRegistryPort"));
            options.put("mbeanServerForConnector", context.getInitParameter("mbeanServerForConnector"));
            JMXHelper.enableJMXSecurity((String)applicationName, options, (Configuration)configuration, (AccessControllerUtils)authUtils);
        }
        logger.debug("#####  ContextListener initialized  #####");
    }

    private AccessControllerUtils initAuthorization(ServletContext context, String webappHomePath, String applicationName) {
        logger.debug(" ### initializing authorization ### ");
        String authorizationConfigurationLocation = null;
        authorizationConfigurationLocation = context.getInitParameter("authorizationConfigurationLocation") != null ? ContextUtil.getContextPath(context, context.getInitParameter("authorizationConfigurationLocation")) : ContextUtil.getContextPath(context, "/WEB-INF/conf/jGuard/authorizationConfiguration.xml");
        Map authorizationSettings = AuthorizationHelper.loadConfiguration((String)authorizationConfigurationLocation, (String)webappHomePath);
        String authorizationScope = null;
        if (authorizationSettings.get("scope") != null) {
            authorizationScope = (String)authorizationSettings.get("scope");
        } else {
            authorizationScope = "local";
            context.setAttribute("authorizationScope", (Object)authorizationScope);
        }
        logger.info(" authorization scope = " + authorizationScope);
        AuthorizationManager authorizationManager = AuthorizationHelper.initAuthorization((Map)authorizationSettings, (String)applicationName);
        AccessControllerUtils authorizationUtils = null;
        MultipleAppPolicy policy = null;
        if ("jvm".equalsIgnoreCase(authorizationScope)) {
            PolicyHelper.installPolicyOnJVM();
            policy = (MultipleAppPolicy)Policy.getPolicy();
            authorizationUtils = new AccessControllerUtils();
        } else {
            policy = new MultipleAppPolicy();
            authorizationUtils = new AccessControllerUtils((Policy)policy);
        }
        policy.registerPermissionProvider((Object)Thread.currentThread().getContextClassLoader(), (PermissionProvider)authorizationManager);
        context.setAttribute("authorizationUtils", (Object)authorizationUtils);
        context.setAttribute("authorizationManager", (Object)authorizationManager);
        logger.debug(" ### authorization initialized ### ");
        return authorizationUtils;
    }

    private void initAuthentication(ServletContext context, String webappHomePath, String applicationName) {
        logger.debug(" ### initializing authentication ### ");
        String authenticationConfigurationLocation = null;
        authenticationConfigurationLocation = context.getInitParameter("authenticationConfigurationLocation") != null ? ContextUtil.getContextPath(context, context.getInitParameter("authenticationConfigurationLocation")) : ContextUtil.getContextPath(context, "/WEB-INF/conf/jGuard/authenticationConfiguration.xml");
        Map authenticationSettings = AuthenticationHelper.loadConfiguration((String)authenticationConfigurationLocation, (String)webappHomePath);
        String authenticationScope = null;
        authenticationScope = authenticationSettings.get("scope") != null ? (String)authenticationSettings.get("scope") : "local";
        logger.info(" authentication scope = " + authenticationScope);
        JGuardConfiguration jGuardConf = null;
        logger.info(" authentication scope = " + authenticationScope);
        if ("jvm".equalsIgnoreCase(authenticationScope)) {
            jGuardConf = (JGuardConfiguration)Configuration.getConfiguration();
        } else {
            jGuardConf = new JGuardConfiguration();
            context.setAttribute("authenticationScope", (Object)authenticationScope);
            context.setAttribute("jGuardConfiguration", (Object)jGuardConf);
        }
        AuthenticationManager authenticationManager = AuthenticationHelper.initAuthentication((JGuardConfiguration)jGuardConf, (Map)authenticationSettings, (String)applicationName);
        context.setAttribute("authenticationManager", (Object)authenticationManager);
        logger.debug(" ### authentication initialized ### ");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

