/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import net.sf.jguard.core.authentication.AuthenticationUtils;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.jee.authentication.http.JEERequestWrapperUtil;

public class JGuardServletRequestWrapper
extends HttpServletRequestWrapper {
    private Map headers = null;
    private HttpServletRequest request;

    public JGuardServletRequestWrapper(HttpServletRequest req) {
        super(req);
        this.request = req;
        this.headers = new HashMap();
    }

    public boolean isUserInRole(String role) {
        HttpSession session = this.request.getSession(true);
        AuthenticationUtils authUtils = (AuthenticationUtils)session.getAttribute("authenticationUtils");
        String applicationName = (String)session.getServletContext().getAttribute("applicationName");
        return JEERequestWrapperUtil.isUserInRole(applicationName, role, authUtils);
    }

    public Principal getUserPrincipal() {
        AuthenticationUtils authUtils = (AuthenticationUtils)this.request.getSession(true).getAttribute("authenticationUtils");
        return JEERequestWrapperUtil.getUserPrincipal(authUtils);
    }

    public String getRemoteUser() {
        AuthenticationUtils authUtils = (AuthenticationUtils)this.request.getSession(true).getAttribute("authenticationUtils");
        AuthenticationManager authManager = (AuthenticationManager)this.request.getSession(true).getServletContext().getAttribute("authenticationManager");
        if (authManager == null) {
            return null;
        }
        return JEERequestWrapperUtil.getRemoteUser(authUtils, authManager);
    }

    public void setHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
    }

    public String getHeader(String headerName) {
        if (this.headers.containsKey(headerName)) {
            return (String)this.headers.get(headerName);
        }
        return super.getHeader(headerName);
    }
}

