/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.AuthenticationUtils;
import net.sf.jguard.core.authentication.Stateful;
import net.sf.jguard.core.authorization.AuthorizationBindings;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import net.sf.jguard.ext.authentication.AbstractAuthenticationBindings;
import net.sf.jguard.jee.authentication.callbacks.HttpServletCallbackHandler;
import net.sf.jguard.jee.authentication.http.AbstractJEEAuthenticationBindings;
import net.sf.jguard.jee.authentication.http.AuthSchemesHelper;
import net.sf.jguard.jee.authentication.http.JGuardServletRequestWrapper;
import net.sf.jguard.jee.authorization.http.HttpAccessControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletAuthenticationBindings
extends AbstractJEEAuthenticationBindings
implements Stateful {
    private static final Logger logger = LoggerFactory.getLogger((String)(class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings == null ? (class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings = HttpServletAuthenticationBindings.class$("net.sf.jguard.jee.authentication.http.HttpServletAuthenticationBindings")) : class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings).getName());
    private String indexURI;
    private String logonURI;
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings;

    public HttpServletAuthenticationBindings(AuthorizationBindings authZBindings) {
        super(authZBindings);
    }

    public void process(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        context.setAttribute("servletRequest", (Object)new JGuardServletRequestWrapper(request));
    }

    public boolean authenticationFailed(AccessContext context) {
        context.setAttribute("redirect", (Object)"true");
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getAttribute("servletResponse");
        if (response.isCommitted()) {
            logger.warn(" response is already committed ");
        }
        if ("BASIC".equalsIgnoreCase(this.authScheme)) {
            HttpServletCallbackHandler.buildBasicChallenge(response, (String)request.getSession(true).getServletContext().getAttribute("applicationName"));
            return false;
        }
        if (this.authenticationFailedPermission != null && !((URLPermission)this.authenticationFailedPermission).getURI().equals("")) {
            try {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + ((URLPermission)this.authenticationFailedPermission).getURI()));
                logger.debug("authentication failed redirect to " + ((URLPermission)this.authenticationFailedPermission).getURI());
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                return false;
            }
            logger.debug(" NOT BASIC AUTHENTICATION - user is not authenticated  redirect to " + request.getContextPath() + ((URLPermission)this.authenticationFailedPermission).getURI());
        } else {
            this.authZbindings.accessDenied(context);
        }
        return true;
    }

    public boolean authenticationSucceed(AccessContext context) {
        context.setAttribute("redirect", (Object)"true");
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getAttribute("servletResponse");
        String redirectURI = this.indexURI;
        URLPermission lastAccessDeniedPermission = (URLPermission)this.getSessionAttribute(context, "lastAccessDeniedPermission");
        String lastAccessDeniedURI = lastAccessDeniedPermission == null ? this.logonURI : lastAccessDeniedPermission.getURI();
        AuthenticationUtils authenticationUtils = this.getAuthenticationUtils(context);
        if (!response.isCommitted()) {
            this.setSessionAttribute(context, "authenticationUtils", authenticationUtils);
        }
        if (lastAccessDeniedURI != null && !"".equals(lastAccessDeniedURI)) {
            if (this.goToLastAccessDeniedUriOnSuccess) {
                redirectURI = lastAccessDeniedURI;
            } else if (!HttpAccessControllerUtils.hasPermission(request, this.indexPermission)) {
                redirectURI = this.logonURI;
            }
        }
        logger.debug(" user is authenticated ", (Object)(" redirect to " + redirectURI));
        if (!response.isCommitted()) {
            try {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + redirectURI));
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    protected void init(Map settings) {
        String tmpValue;
        this.indexURI = (String)settings.get("indexURI");
        this.indexPermission = new URLPermission("indexURI", this.indexURI);
        this.authenticationFailedPermission = new URLPermission("authenticationFailedURI", (String)settings.get("authenticationFailedURI"));
        this.logonProcessPermission = new URLPermission("logonProcessURI", (String)settings.get("logonProcessURI"));
        String logonURIStr = (String)settings.get("logonURI");
        AbstractAuthenticationBindings.logonPermission = new URLPermission("logonURI", logonURIStr);
        this.logoffPermission = new URLPermission("logoffURI", (String)settings.get("logoffURI"));
        this.authScheme = (String)settings.get("authScheme");
        HttpServletCallbackHandler.setAuthSchemes(this.authScheme);
        this.authSchemes = AuthSchemesHelper.validateAuthScheme(this.authScheme);
        if (this.authSchemes.contains("FORM")) {
            HttpServletCallbackHandler.setLoginField((String)settings.get("loginField"));
            HttpServletCallbackHandler.setPasswordField((String)settings.get("passwordField"));
        }
        if ("false".equalsIgnoreCase(tmpValue = (String)settings.get("goToLastAccessDeniedUriOnSuccess")) || "no".equalsIgnoreCase(tmpValue)) {
            this.goToLastAccessDeniedUriOnSuccess = false;
        }
    }

    public CallbackHandler getCallbackHandler(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getAttribute("servletResponse");
        HttpServletCallbackHandler cbh = new HttpServletCallbackHandler(request, response);
        return cbh;
    }

    public Object getSessionAttribute(AccessContext context, String key) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpSession session = request.getSession(true);
        return session.getAttribute(key);
    }

    public void setSessionAttribute(AccessContext context, String key, Object value) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpSession session = request.getSession(true);
        session.setAttribute(key, value);
    }

    public void removeSessionAttribute(AccessContext context, String key) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpSession session = request.getSession(true);
        session.removeAttribute(key);
    }

    public void removeApplicationAttribute(AccessContext context, String key) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        ServletContext servletContext = request.getSession(true).getServletContext();
        servletContext.removeAttribute(key);
    }

    public void removeRequestAttribute(AccessContext context, String key) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        request.removeAttribute(key);
    }

    public void setRequestAttribute(AccessContext context, String key, Object value) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        request.setAttribute(key, value);
    }

    public void setApplicationAttribute(AccessContext context, String key, Object value) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpSession session = request.getSession(true);
        session.getServletContext().setAttribute(key, value);
    }

    public Object getRequestAttribute(AccessContext context, String key) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        return request.getAttribute(key);
    }

    public Object getApplicationAttribute(AccessContext context, String key) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        ServletContext servletContext = request.getSession(true).getServletContext();
        return servletContext.getAttribute(key);
    }

    public boolean isStateful() {
        return true;
    }

    public void invalidateSession(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

