/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.io.IOException;
import java.security.Policy;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import net.sf.jguard.core.CoreConstants;
import net.sf.jguard.core.PolicyEnforcementPoint;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.jee.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jguard$jee$authentication$http$AccessFilter == null ? (class$net$sf$jguard$jee$authentication$http$AccessFilter = AccessFilter.class$("net.sf.jguard.jee.authentication.http.AccessFilter")) : class$net$sf$jguard$jee$authentication$http$AccessFilter));
    public static final String SERVLET_REQUEST = "servletRequest";
    public static final String SERVLET_RESPONSE = "servletResponse";
    public static final String FILTER_CHAIN = "filterChain";
    private static String applicationName;
    private PolicyEnforcementPoint pep = null;
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$http$AccessFilter;
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings;
    static /* synthetic */ Class class$net$sf$jguard$jee$authorization$http$HttpServletAuthorizationBindings;
    static /* synthetic */ Class class$net$sf$jguard$jee$provisioning$HttpServletProvisioningServicePoint;

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.debug("server info = " + filterConfig.getServletContext().getServerInfo());
        logger.debug("servletContextName=" + filterConfig.getServletContext().getServletContextName());
        logger.debug("servlet Real Path=" + ContextUtil.getContextPath(filterConfig.getServletContext(), "/"));
        logger.debug("current Policy=" + Policy.getPolicy());
        ServletContext context = filterConfig.getServletContext();
        applicationName = context.getServletContextName();
        if (applicationName == null) {
            logger.error(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
            throw new ServletException(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
        }
        HashMap<Object, String> options = new HashMap<Object, String>();
        String authenticationBindingsImpl = context.getInitParameter("authenticationBindings");
        if (authenticationBindingsImpl == null || authenticationBindingsImpl.equals("")) {
            authenticationBindingsImpl = (class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings == null ? (class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings = AccessFilter.class$("net.sf.jguard.jee.authentication.http.HttpServletAuthenticationBindings")) : class$net$sf$jguard$jee$authentication$http$HttpServletAuthenticationBindings).getName();
        }
        options.put("authenticationBindings", authenticationBindingsImpl);
        String filterConfigurationLocation = ContextUtil.getContextPath(context, filterConfig.getInitParameter("configurationLocation"));
        options.put("configurationLocation", filterConfigurationLocation);
        String authenticationScope = context.getInitParameter("authenticationScope");
        if (authenticationScope == null || "".equals(authenticationScope)) {
            authenticationScope = "local";
        }
        options.put(CoreConstants.AUTHENTICATION_SCOPE, authenticationScope);
        String authorizationBindingsImpl = context.getInitParameter("authorizationBindings");
        if (authorizationBindingsImpl == null || authorizationBindingsImpl.equals("")) {
            authorizationBindingsImpl = (class$net$sf$jguard$jee$authorization$http$HttpServletAuthorizationBindings == null ? (class$net$sf$jguard$jee$authorization$http$HttpServletAuthorizationBindings = AccessFilter.class$("net.sf.jguard.jee.authorization.http.HttpServletAuthorizationBindings")) : class$net$sf$jguard$jee$authorization$http$HttpServletAuthorizationBindings).getName();
        }
        options.put("authorizationBindings", authorizationBindingsImpl);
        String provisioningServicePointImpl = context.getInitParameter("provisioningServicePoint");
        if (provisioningServicePointImpl == null || provisioningServicePointImpl.equals("")) {
            provisioningServicePointImpl = (class$net$sf$jguard$jee$provisioning$HttpServletProvisioningServicePoint == null ? (class$net$sf$jguard$jee$provisioning$HttpServletProvisioningServicePoint = AccessFilter.class$("net.sf.jguard.jee.provisioning.HttpServletProvisioningServicePoint")) : class$net$sf$jguard$jee$provisioning$HttpServletProvisioningServicePoint).getName();
        }
        options.put("provisioningServicePoint", provisioningServicePointImpl);
        options.put("applicationName", applicationName);
        this.pep = new PolicyEnforcementPoint(options);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        AccessContext context = new AccessContext();
        context.setAttribute(SERVLET_REQUEST, (Object)servletRequest);
        context.setAttribute(SERVLET_RESPONSE, (Object)servletResponse);
        context.setAttribute(FILTER_CHAIN, (Object)filterChain);
        try {
            this.pep.process(context);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            response.sendError(500);
        }
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

