/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.Configuration;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.AuthenticationUtils;
import net.sf.jguard.core.authentication.Stateful;
import net.sf.jguard.core.authorization.AuthorizationBindings;
import net.sf.jguard.ext.authentication.AbstractAuthenticationBindings;
import net.sf.jguard.ext.util.XMLUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJEEAuthenticationBindings
extends AbstractAuthenticationBindings {
    protected boolean local = false;
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jguard$jee$authentication$http$AbstractJEEAuthenticationBindings == null ? (class$net$sf$jguard$jee$authentication$http$AbstractJEEAuthenticationBindings = AbstractJEEAuthenticationBindings.class$("net.sf.jguard.jee.authentication.http.AbstractJEEAuthenticationBindings")) : class$net$sf$jguard$jee$authentication$http$AbstractJEEAuthenticationBindings));
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$http$AbstractJEEAuthenticationBindings;

    public AbstractJEEAuthenticationBindings(AuthorizationBindings authorizationBindings) {
        super(authorizationBindings);
    }

    public void init(String location, String authenticationScope) {
        Map settings = AbstractJEEAuthenticationBindings.loadFilterConfiguration(location);
        this.init(settings);
        this.local = !"jvm".equalsIgnoreCase(authenticationScope);
    }

    protected abstract void init(Map var1);

    private static Map loadFilterConfiguration(String configurationLocation) {
        Element goToLastAccessDeniedUriOnSuccessElement;
        Element passwordElement;
        Document doc = XMLUtils.read((String)configurationLocation);
        Element authentication = doc.getRootElement();
        HashMap<String, String> filterSettings = new HashMap<String, String>();
        filterSettings.put("indexURI", authentication.element("indexURI").getTextTrim());
        filterSettings.put("authenticationFailedURI", authentication.element("authenticationFailedURI").getTextTrim());
        filterSettings.put("logonProcessURI", authentication.element("logonProcessURI").getTextTrim());
        filterSettings.put("logonURI", authentication.element("logonURI").getTextTrim());
        filterSettings.put("logoffURI", authentication.element("logoffURI").getTextTrim());
        filterSettings.put("authScheme", authentication.element("authScheme").getTextTrim());
        Element loginElement = authentication.element("loginField");
        if (loginElement != null) {
            filterSettings.put("loginField", loginElement.getTextTrim());
        }
        if ((passwordElement = authentication.element("passwordField")) != null) {
            filterSettings.put("passwordField", passwordElement.getTextTrim());
        }
        if ((goToLastAccessDeniedUriOnSuccessElement = authentication.element("goToLastAccessDeniedUriOnSuccess")) != null) {
            filterSettings.put("goToLastAccessDeniedUriOnSuccess", goToLastAccessDeniedUriOnSuccessElement.getTextTrim());
        }
        return filterSettings;
    }

    public AuthenticationUtils getAuthenticationUtils(AccessContext context) {
        AuthenticationUtils authenticationUtils = null;
        if (this.isStateful()) {
            authenticationUtils = (AuthenticationUtils)((Stateful)this).getSessionAttribute(context, "authenticationUtils");
        }
        if (authenticationUtils != null && authenticationUtils.getSubject() == null) {
            logger.debug(" subject into AuthenticationUtils is null ");
            authenticationUtils.logout();
            ((Stateful)this).removeSessionAttribute(context, "authenticationUtils");
            authenticationUtils = null;
        }
        if (authenticationUtils == null) {
            Configuration configuration = (Configuration)this.getApplicationAttribute(context, "jGuardConfiguration");
            authenticationUtils = this.local ? new AuthenticationUtils(configuration) : new AuthenticationUtils();
            if (this.isStateful()) {
                ((Stateful)this).setSessionAttribute(context, "authenticationUtils", (Object)authenticationUtils);
            }
        }
        return authenticationUtils;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

