/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.callbacks;

import com.octo.captcha.service.CaptchaService;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jguard.core.authentication.AuthenticationUtils;
import net.sf.jguard.core.authentication.callbacks.InetAddressCallback;
import net.sf.jguard.ext.authentication.callbacks.CallbackHandlerUtils;
import net.sf.jguard.ext.authentication.callbacks.JCaptchaCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;

public class HttpServletCallbackHandler
implements CallbackHandler {
    public static final String AUTHORIZATION = "Authorization";
    private static final String BASIC_REALM = "Basic realm=\"";
    private static final String NO_CACHE_AUTHORIZATION = "no-cache=\"Authorization\"";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jguard$jee$authentication$callbacks$HttpServletCallbackHandler == null ? (class$net$sf$jguard$jee$authentication$callbacks$HttpServletCallbackHandler = HttpServletCallbackHandler.class$("net.sf.jguard.jee.authentication.callbacks.HttpServletCallbackHandler")) : class$net$sf$jguard$jee$authentication$callbacks$HttpServletCallbackHandler));
    private HttpServletRequest httpServletRequest;
    private HttpServletResponse httpServletResponse;
    private static String authSchemes = "FORM";
    private static String loginField = "login";
    private static String passwordField = "password";
    private boolean afterRegistration;
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$callbacks$HttpServletCallbackHandler;

    public HttpServletCallbackHandler() {
    }

    public HttpServletCallbackHandler(HttpServletRequest request, HttpServletResponse response) {
        this.httpServletRequest = request;
        Boolean ar = (Boolean)request.getAttribute("registrationDone");
        if (ar != null) {
            this.afterRegistration = ar;
        }
        this.httpServletResponse = response;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        boolean httpRelatedAuthScheme = false;
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (callback instanceof InetAddressCallback) {
                String remoteAddress = this.httpServletRequest.getRemoteAddr();
                String remoteHost = this.httpServletRequest.getRemoteHost();
                InetAddressCallback inetAddressCallback = (InetAddressCallback)callback;
                inetAddressCallback.setHostAdress(remoteAddress);
                if (remoteAddress.equals(remoteHost)) {
                    String resolvedHostName = remoteAddress;
                    try {
                        resolvedHostName = this.reverseDns(remoteAddress);
                    }
                    catch (UnknownHostException uhe) {
                        logger.warn(" host bound to address " + remoteAddress + "cannot be resolved", (Throwable)uhe);
                    }
                    inetAddressCallback.setHostName(resolvedHostName);
                    continue;
                }
                inetAddressCallback.setHostName(remoteHost);
                continue;
            }
            if (!(callback instanceof LanguageCallback)) continue;
            LanguageCallback languageCallback = (LanguageCallback)callback;
            Locale locale = this.httpServletRequest.getLocale();
            languageCallback.setLocale(locale);
        }
        logger.debug("authSchemes=" + authSchemes);
        String[] schemes = authSchemes.split(",");
        List<String> authSchemesList = Arrays.asList(schemes);
        Iterator<String> itAutSchemes = authSchemesList.iterator();
        while (itAutSchemes.hasNext()) {
            boolean certificatesFound;
            String scheme = itAutSchemes.next();
            if (!httpRelatedAuthScheme && "FORM".equalsIgnoreCase(scheme)) {
                this.grabFormCredentials(this.httpServletRequest, callbacks);
                httpRelatedAuthScheme = true;
            } else if (!httpRelatedAuthScheme && "BASIC".equalsIgnoreCase(scheme)) {
                this.grabBasicCredentials(this.httpServletRequest, callbacks);
                httpRelatedAuthScheme = true;
            } else if (!httpRelatedAuthScheme && "DIGEST".equalsIgnoreCase(scheme)) {
                this.grabDigestCredentials(this.httpServletRequest, callbacks);
                httpRelatedAuthScheme = true;
            }
            if (!"CLIENT-CERT".equalsIgnoreCase(scheme) || (certificatesFound = this.grabClientCertCredentials(this.httpServletRequest, callbacks))) continue;
            logger.info(" X509 certificates are not found ");
        }
    }

    public static void buildBasicChallenge(HttpServletResponse response, String realmName) {
        StringBuffer responseValue = new StringBuffer();
        responseValue.append(BASIC_REALM);
        responseValue.append(realmName);
        responseValue.append("\"");
        response.setHeader(WWW_AUTHENTICATE, responseValue.toString());
        response.setHeader(CACHE_CONTROL, NO_CACHE_AUTHORIZATION);
        response.setStatus(401);
    }

    private boolean grabBasicCredentials(HttpServletRequest request, Callback[] callbacks) {
        String encodedLoginAndPwd = request.getHeader(AUTHORIZATION);
        String encoding = request.getCharacterEncoding();
        return CallbackHandlerUtils.grabBasicCredentials((String)encodedLoginAndPwd, (String)encoding, (Callback[])callbacks);
    }

    private boolean grabFormCredentials(HttpServletRequest request, Callback[] callbacks) {
        boolean result = false;
        HttpSession session = request.getSession();
        for (int i = 0; i < callbacks.length; ++i) {
            PasswordCallback pc;
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                String login = this.httpServletRequest.getParameter(loginField);
                nc.setName(login);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                pc = (PasswordCallback)callbacks[i];
                String strPwd = this.httpServletRequest.getParameter(passwordField);
                if (strPwd != null && strPwd != "") {
                    pc.setPassword(strPwd.toCharArray());
                    continue;
                }
                pc.setPassword(null);
                continue;
            }
            if (!(callbacks[i] instanceof JCaptchaCallback)) continue;
            pc = (JCaptchaCallback)callbacks[i];
            pc.setCaptchaAnswer(this.httpServletRequest.getParameter("captchaAnswer"));
            pc.setCaptchaService((CaptchaService)session.getServletContext().getAttribute("captchaService"));
            Subject subject = ((AuthenticationUtils)session.getAttribute("authenticationUtils")).getSubject();
            if (subject == null || this.afterRegistration) {
                pc.setSkipJCaptchaChallenge(true);
            }
            pc.setSessionID(session.getId());
        }
        result = true;
        return result;
    }

    private boolean grabDigestCredentials(HttpServletRequest request, Callback[] callbacks) {
        boolean result = false;
        String login = "";
        String password = "";
        if (login == null || password == null) {
            login = "guest";
            password = "guest";
        } else {
            result = true;
        }
        return result;
    }

    private boolean grabClientCertCredentials(HttpServletRequest request, Callback[] callbacks) {
        if (!request.isSecure()) {
            logger.warn(" certificate-based authentication MUST be do in secure mode ");
            logger.warn(" but connection is do with the non secured protocol " + request.getScheme());
            return false;
        }
        Object[] objects = (Object[])request.getAttribute("javax.servlet.request.X509Certificate");
        return CallbackHandlerUtils.grabClientCertCredentials((Callback[])callbacks, (Object[])objects);
    }

    public static void buildFormChallenge(FilterChain chain, ServletRequest req, ServletResponse res) throws IOException, ServletException {
        chain.doFilter(req, res);
    }

    public static void buildDigestChallenge(HttpServletRequest request, HttpServletResponse response, String realm) {
        String responseValue = CallbackHandlerUtils.buildDigestChallenge((String)realm);
        response.setHeader(WWW_AUTHENTICATE, responseValue.toString());
        response.setStatus(401);
    }

    public static String getPasswordField() {
        return passwordField;
    }

    public static void setPasswordField(String passwordField) {
        if (passwordField != null) {
            HttpServletCallbackHandler.passwordField = passwordField;
        }
    }

    public static String getLoginField() {
        return loginField;
    }

    public static void setLoginField(String loginField) {
        if (loginField != null) {
            HttpServletCallbackHandler.loginField = loginField;
        }
    }

    private String reverseDns(String hostIp) throws IOException {
        int dclass;
        int type;
        Object opt = null;
        ExtendedResolver res = new ExtendedResolver();
        Name name = ReverseMap.fromAddress((String)hostIp);
        Record rec = Record.newRecord((Name)name, (int)(type = 12), (int)(dclass = 1));
        Message query = Message.newQuery((Record)rec);
        Message response = res.send(query);
        Record[] answers = response.getSectionArray(1);
        if (answers.length == 0) {
            return hostIp;
        }
        return answers[0].rdataToString();
    }

    public String getAuthScheme() {
        return authSchemes;
    }

    public static void setAuthSchemes(String schemes) {
        authSchemes = schemes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

