/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/

package net.sf.jguard.jee.authorization.http;

import java.io.IOException;
import java.security.Permission;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import net.sf.jguard.core.CoreConstants;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authorization.AuthorizationBindings;
import net.sf.jguard.jee.authentication.http.AccessFilter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public class HttpServletAuthorizationBindings implements AuthorizationBindings{
    
    private static  final Logger logger = LoggerFactory.getLogger(HttpServletAuthorizationBindings.class.getName());
    
    private PermissionFactory permissionFactory;
    
    
    /** Creates a new instance of HttpServletAuthorizationBindings */
    public HttpServletAuthorizationBindings() {
        permissionFactory = new HttpPermissionFactory();
    }


    public Permission getPermissionRequested(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute(AccessFilter.SERVLET_REQUEST);
        return permissionFactory.getPermission(request);
    }

    public void setLastAccessDeniedPermission(AccessContext context, Permission permission) {
                HttpServletRequest request = (HttpServletRequest)context.getAttribute(AccessFilter.SERVLET_REQUEST);
                HttpSession session = request.getSession(true);
                session.setAttribute(CoreConstants.LAST_ACCESS_DENIED_PERMISSION,permission);
    }

    public void accessDenied(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute(AccessFilter.SERVLET_REQUEST);
        HttpServletResponse response = (HttpServletResponse)context.getAttribute(AccessFilter.SERVLET_RESPONSE);
        
        
        //redirect to accessDeniedURI because user is not authorized
        //to access to this resource
        if (logger.isDebugEnabled()) {
            logger.debug(" access denied to "+request.getRequestURI());
        }

        logger.debug(" access is denied to "+request.getRequestURI()+" accessDeniedURI is not defined  jGuard send 401 http code ");
        response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
        try {
            if(!response.isCommitted()){
                response.sendError(HttpServletResponse.SC_UNAUTHORIZED,"access is denied to "+request.getRequestURI());
            }
        } catch (IOException ex) {
           throw new RuntimeException(ex.getMessage(),ex);
        }
	
    }

    public void authorize(AccessContext context) {
         HttpServletRequest request = (HttpServletRequest)context.getAttribute(AccessFilter.SERVLET_REQUEST);
         HttpServletResponse response = (HttpServletResponse)context.getAttribute(AccessFilter.SERVLET_RESPONSE);
         FilterChain chain = (FilterChain)context.getAttribute(AccessFilter.FILTER_CHAIN);
        	if (logger.isDebugEnabled()) {
			logger.debug("doFilter() -  access authorized to "+ request.getRequestURI());
		}

			try{
			chain.doFilter(request,response);
			}catch(Throwable t){
				logger.error(t.getMessage(),t);
                                try {
                                    response.sendError(HttpServletResponse.SC_SERVICE_UNAVAILABLE);
                                } catch (IOException ex) {
                                    throw new RuntimeException(ex.getMessage(),ex);
                                }
			}
    }
    
}
