/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.jee.authentication.http;

import java.security.Principal;
import java.util.Iterator;
import java.util.Set;

import javax.security.auth.Subject;
import net.sf.jguard.core.authentication.AuthenticationException;

import net.sf.jguard.core.authentication.AuthenticationUtils;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.core.principals.RolePrincipal;
import net.sf.jguard.core.principals.UserPrincipal;
import net.sf.jguard.ext.util.SubjectUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * utility class for JEE wrappers like {@link HttpServletRequestWrapper} or
 * {@link  JGuardPortletRequestWrapper}.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 *
 */
public class JEERequestWrapperUtil {

	private static Logger logger = LoggerFactory.getLogger(JEERequestWrapperUtil.class);
	
	/**
	 * return the 'identity' credential value converted to a String.
	 * note that <strong>only one</strong> credential must be an identity credential.  
	 * @param authUtils
	 * @return
	 */
	public static String getRemoteUser(AuthenticationUtils authUtils,AuthenticationManager authManager) {
            String remoteUser = null;
            Subject subject = authUtils.getSubject();
                if(subject==null){
                    return remoteUser;
                }else{
                    
                        JGuardCredential identityCred = SubjectUtils.getIdentityCredential(subject, authManager);
                        Object value  = identityCred.getValue();
                        if(value!=null){
                            remoteUser = value.toString();
                        }
                    
                }
            return remoteUser;
	}
	
	public static boolean isUserInRole(String applicationName,String role, AuthenticationUtils authUtils) {
		if(applicationName == null||"".equals(applicationName)){
			logger.error("applicationName is null or empty = "+applicationName);
		}
		if(role == null||"".equals(role)){
			logger.error("role is null or empty = "+role);
		}
		String composedRoleName = new StringBuffer(applicationName).append('#').append(role).toString();
		Subject subject = authUtils.getSubject();
    	Set principals = subject.getPrincipals(RolePrincipal.class);
    	Iterator itPrincipals = principals.iterator();
    	while(itPrincipals.hasNext()){
    		Principal principal = (Principal)itPrincipals.next();
    		if(composedRoleName.equals(principal.getName())){
    			return true;
    		}
    	}
    	return false;
	}
	
	/**
	 * return a {@link UserPrincipal} which embeds a {@link Subject}.
         * 
	 * @param authUtils
	 * @return
	 */
	public static Principal getUserPrincipal(AuthenticationUtils authUtils) {
                if(authUtils==null){
                    return null;
                }
		Subject subject =  authUtils.getSubject();
                return new UserPrincipal(subject);
	}
	
}
