/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.jee.authentication.http;


/**
 * Interface whick regroup all of the <b>HTTP</b> Constants used.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 * @author <a href="mailto:tandilero@users.sourceforge.net">Maximiliano Batelli</a>
 *
 */
public interface HttpConstants {
	public final static String DEBUG = "debug";

	public final static String WEBAPP_HOME_PATH="webappHome";

	public final static String AUTHZ_UTILS = "authorizationUtils";

	public final static String USERS_IN_SESSION= "sessionList";
	//fields names used in FORM authentication
    public final static String LOGIN_FIELD = "loginField";
    public final static String PASSWORD_FIELD = "passwordField";

    //uri used to configure jGuard in a webapp
    public final static String INDEX_URI = "indexURI";
    public final static String AUTHENTICATION_FAILED_URI = "authenticationFailedURI";
    public final static String LOGON_PROCESS_URI = "logonProcessURI";
    public final static String LOGON_URI = "logonURI";
    public final static String LOGOFF_URIS = "logoffURIs";
    public final static String LOGOFF_URI = "logoffURI";
    public final static String REGISTER_PROCESS_URI = "registerProcessURI";
    public final static String REGISTER_URI = "registerURI";
    
    public final static String GO_TO_LAST_ACCESS_DENIED_URI_ON_SUCCESS = "goToLastAccessDeniedUriOnSuccess";
    

    // authentication schemes List
    public final static String AUTH_SCHEMES ="authScheme";
    public final static String AUTH_SCHEME ="authScheme";
    public final static String CURRENT_AUTH_SCHEME ="currentAuthScheme";
    
    
	//authentication schemes
	public final static String BASIC_AUTH = "BASIC";
	public final static String CLIENT_CERT_AUTH = "CLIENT-CERT";
	public final static String DIGEST_AUTH = "DIGEST";
	public final static String FORM_AUTH = "FORM";

	//ContextListener locations
	public final static String DEFAULT_AUTHENTICATION_CONFIGURATION_LOCATION="/WEB-INF/conf/jGuard/authenticationConfiguration.xml";
	public final static String DEFAULT_AUTHORIZATION_CONFIGURATION_LOCATION="/WEB-INF/conf/jGuard/authorizationConfiguration.xml";
	public final static String AUTHENTICATION_CONFIGURATION_LOCATION="authenticationConfigurationLocation";
	public final static String AUTHORIZATION_CONFIGURATION_LOCATION="authorizationConfigurationLocation";

	public static final String JGUARD_CONFIGURATION = "jGuardConfiguration";

	public static final String REALPATH = "realpath";

    

	

}

