/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/

package net.sf.jguard.jee.authentication.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * Authentication utility class to handle authentication schemes.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public class AuthSchemesHelper {
	/**
	 * return the authScheme used to try to authenticate the user
	 * among an AuthSChemes list. 
	 * @param request
	 * @return
	 */
	public static String getCurrentAuthScheme(HttpServletRequest request) {
		HttpSession session = request.getSession(true);
		String currentAuthScheme = (String)session.getAttribute(HttpConstants.CURRENT_AUTH_SCHEME);
		if(currentAuthScheme==null){
			List authSchemes = (List)session.getAttribute(HttpConstants.AUTH_SCHEMES);
			currentAuthScheme  = (String)authSchemes.get(0);
			session.setAttribute(HttpConstants.CURRENT_AUTH_SCHEME,currentAuthScheme);
		}
		return currentAuthScheme;
	}
	
	/**
	 * advance tp to the next scheme. 
	 * @param request
	 * @return <strong>true</strong> if there is a next scheme, <strong>false</strong> otherwise.
	 */
	public static boolean advanceToNextScheme(HttpServletRequest request){
		HttpSession session = request.getSession(true);
		List authSchemes = (List)session.getAttribute(HttpConstants.AUTH_SCHEMES);
		String oldCurrentScheme = getCurrentAuthScheme(request);
		int oldCurrentSchemeIndex = authSchemes.indexOf(oldCurrentScheme);
		//the end of the scheme array
		//currentScheme is the last scheme
		if(authSchemes.size()<=oldCurrentSchemeIndex+1){
			return false;
		}
		String currentAuthScheme  = (String)authSchemes.get(oldCurrentSchemeIndex+1);
		session.setAttribute(HttpConstants.CURRENT_AUTH_SCHEME,currentAuthScheme);
		return true;
	}
	
	
	/**
	 * validate that the authentication schemes are handled by jGuard.
	 * @param authSchemes
	 * @throws ServletException
	 */
	public static Collection validateAuthScheme(String authSchemes) {
		Collection authSchemesList = null;
		//default authentication is FORM authentication
        if(authSchemes==null){
			authSchemes = HttpConstants.FORM_AUTH;
			authSchemesList = new ArrayList();
			authSchemesList.add(authSchemes);
			return authSchemesList;
        }

        String[] schemes = authSchemes.split(",");
		authSchemesList = Arrays.asList(schemes);
		Iterator itAutSchemes = authSchemesList.iterator();
		while(itAutSchemes.hasNext()){
			String autScheme = (String)itAutSchemes.next();
			if(!HttpConstants.FORM_AUTH.equalsIgnoreCase(autScheme)
				&&!HttpConstants.BASIC_AUTH.equalsIgnoreCase(autScheme)
				&&!HttpConstants.DIGEST_AUTH.equalsIgnoreCase(autScheme)
				&&!HttpConstants.CLIENT_CERT_AUTH.equalsIgnoreCase(autScheme)){
				throw new IllegalArgumentException(
						" each authentication scheme should be 'BASIC','FORM','DIGEST',or 'CLIENT-CERT' and not '"
						+authSchemes+"' ");
			}
			autScheme = autScheme.toUpperCase();
		}
		
		return authSchemesList;

	}



}
