/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.jee.authentication.http;

import java.util.HashMap;
import java.util.Map;

import javax.security.auth.login.Configuration;

import net.sf.jguard.core.CoreConstants;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.AuthenticationUtils;
import net.sf.jguard.core.authentication.Stateful;
import net.sf.jguard.core.authorization.AuthorizationBindings;
import net.sf.jguard.ext.SecurityConstants;
import net.sf.jguard.ext.authentication.AbstractAuthenticationBindings;
import net.sf.jguard.ext.util.XMLUtils;

import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * abstract class which adds the <strong>SCOPE</strong> notion inherent to JEE applications,
 * and permit to load the settings present in the jGuardFilter.xml file. 
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 *
 */
public abstract class AbstractJEEAuthenticationBindings extends	AbstractAuthenticationBindings {

		protected boolean local = false;
		private static final Logger logger = LoggerFactory.getLogger(AbstractJEEAuthenticationBindings.class);
		
		 public AbstractJEEAuthenticationBindings(AuthorizationBindings authorizationBindings){
		    	super(authorizationBindings);
	    }
	 
		public void init(String location,String authenticationScope) {
	         Map settings = loadFilterConfiguration(location);
	         init(settings);
	         
	         if(SecurityConstants.JVM_SCOPE.equalsIgnoreCase(authenticationScope)){
	              local = false;
	         }else{
	              local = true;
	         }
		}

		protected abstract void init(Map settings);
	 
	 
	   /** load configuration from an XML file.
        * @param configurationLocation
        * @return Map containing filter configuration
        */
		private static Map loadFilterConfiguration(String configurationLocation){
			Document doc = XMLUtils.read(configurationLocation);
			Element authentication = doc.getRootElement();
			Map filterSettings = new HashMap();
			filterSettings.put(HttpConstants.INDEX_URI,authentication.element(HttpConstants.INDEX_URI).getTextTrim());
			filterSettings.put(HttpConstants.AUTHENTICATION_FAILED_URI,authentication.element(HttpConstants.AUTHENTICATION_FAILED_URI).getTextTrim());
			filterSettings.put(HttpConstants.LOGON_PROCESS_URI,authentication.element(HttpConstants.LOGON_PROCESS_URI).getTextTrim());
			filterSettings.put(HttpConstants.LOGON_URI,authentication.element(HttpConstants.LOGON_URI).getTextTrim());

			filterSettings.put(HttpConstants.LOGOFF_URI,authentication.element(HttpConstants.LOGOFF_URI).getTextTrim());
	                

			filterSettings.put(HttpConstants.AUTH_SCHEME,authentication.element(HttpConstants.AUTH_SCHEME).getTextTrim());
			Element loginElement = authentication.element(HttpConstants.LOGIN_FIELD);
			if (loginElement != null){
				filterSettings.put(HttpConstants.LOGIN_FIELD,loginElement.getTextTrim());
			}
			Element passwordElement = authentication.element(HttpConstants.PASSWORD_FIELD);
			if (passwordElement != null){
				filterSettings.put(HttpConstants.PASSWORD_FIELD,passwordElement.getTextTrim());
			}

			Element goToLastAccessDeniedUriOnSuccessElement = authentication.element(HttpConstants.GO_TO_LAST_ACCESS_DENIED_URI_ON_SUCCESS);
			if (goToLastAccessDeniedUriOnSuccessElement != null){
				filterSettings.put(HttpConstants.GO_TO_LAST_ACCESS_DENIED_URI_ON_SUCCESS,goToLastAccessDeniedUriOnSuccessElement.getTextTrim());
			}
			
			return filterSettings;
		}

		
		 /**
	     * grab the {@link AuthenticationUtils} from the session, or create a new one if no one exist.
	     * @param context
	     * @return AuthenticationUtils
	     */
		public AuthenticationUtils getAuthenticationUtils(AccessContext context) {
			AuthenticationUtils authenticationUtils = null;
			if(isStateful()){
				authenticationUtils = (AuthenticationUtils)((Stateful)this).getSessionAttribute(context,CoreConstants.AUTHN_UTILS);
				//auth.getSubject() can return  null if the user in session has been deleted by authenticationManager
                        }
                        
                        //authenticationUtils can be either grabbed from the session, 
                        //or created before in the same call
			if(authenticationUtils!= null && authenticationUtils.getSubject()==null){
				logger.debug(" subject into AuthenticationUtils is null ");
				authenticationUtils.logout();
				((Stateful)this).removeSessionAttribute(context,CoreConstants.AUTHN_UTILS);
				authenticationUtils = null;
			}
			
			
			
			if(authenticationUtils==null){
				Configuration configuration = (Configuration)this.getApplicationAttribute(context,HttpConstants.JGUARD_CONFIGURATION);
				if(local){
					authenticationUtils = new AuthenticationUtils(configuration);
				}else{
					authenticationUtils = new AuthenticationUtils();
				}
				if(isStateful()){
					((Stateful)this).setSessionAttribute(context,CoreConstants.AUTHN_UTILS,authenticationUtils);
				}
			}
	    	return authenticationUtils;
		}
}
