/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import com.octo.captcha.module.config.CaptchaModuleConfig;
import com.octo.captcha.service.CaptchaService;
import com.octo.captcha.service.EhcacheManageableCaptchaService;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CaptchaChallengeBuilder {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$jguard$jee$authentication$http$CaptchaChallengeBuilder == null ? (class$net$sf$jguard$jee$authentication$http$CaptchaChallengeBuilder = CaptchaChallengeBuilder.class$("net.sf.jguard.jee.authentication.http.CaptchaChallengeBuilder")) : class$net$sf$jguard$jee$authentication$http$CaptchaChallengeBuilder));
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$http$CaptchaChallengeBuilder;
    static /* synthetic */ Class class$com$octo$captcha$service$EhcacheManageableCaptchaService;

    public static void buildCaptchaChallenge(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        CaptchaService service = (CaptchaService)session.getServletContext().getAttribute("captchaService");
        if (service == null) {
            logger.debug((Object)"captcha service should be defined ");
            try {
                service = (CaptchaService)Thread.currentThread().getContextClassLoader().loadClass(CaptchaModuleConfig.getInstance().getServiceClass()).newInstance();
                session.getServletContext().setAttribute("captchaService", (Object)service);
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage());
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage());
            }
            logger.debug((Object)(" CAPTCHA SERVICE=" + service.getClass().getName() + " will be defined"));
            if (service.getClass().isAssignableFrom(class$com$octo$captcha$service$EhcacheManageableCaptchaService == null ? (class$com$octo$captcha$service$EhcacheManageableCaptchaService = CaptchaChallengeBuilder.class$("com.octo.captcha.service.EhcacheManageableCaptchaService")) : class$com$octo$captcha$service$EhcacheManageableCaptchaService)) {
                ((EhcacheManageableCaptchaService)service).emptyCaptchaStore();
            }
        } else {
            logger.debug((Object)(" CAPTCHA SERVICE=" + service.getClass().getName()));
        }
        byte[] captchaChallengeAsJpeg = CaptchaChallengeBuilder.buildCaptchaChallenge(session.getId(), request.getLocale(), service);
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        try {
            ServletOutputStream responseOutputStream = response.getOutputStream();
            responseOutputStream.write(captchaChallengeAsJpeg);
            responseOutputStream.flush();
            responseOutputStream.close();
        }
        catch (IOException e) {
            logger.error((Object)" captcha cannot be generated", (Throwable)e);
        }
    }

    private static byte[] buildCaptchaChallenge(String captchaId, Locale locale, CaptchaService service) throws IOException {
        byte[] captchaChallengeAsJpeg = null;
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        logger.debug((Object)("sessionID=" + captchaId));
        BufferedImage challenge = (BufferedImage)service.getChallengeForID(captchaId, locale);
        logger.debug((Object)("challenge=" + service.getQuestionForID(captchaId, locale)));
        logger.debug((Object)(" service=" + service));
        JPEGImageEncoder jpegEncoder = JPEGCodec.createJPEGEncoder((OutputStream)jpegOutputStream);
        jpegEncoder.encode(challenge);
        captchaChallengeAsJpeg = jpegOutputStream.toByteArray();
        return captchaChallengeAsJpeg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

