/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.principals.RolePrincipal;
import net.sf.jguard.core.principals.UserPrincipal;
import net.sf.jguard.jee.authentication.http.HttpAuthenticationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JGuardServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final String LOGIN = "login";
    private static Log logger = LogFactory.getLog((Class)(class$net$sf$jguard$jee$authentication$http$JGuardServletRequestWrapper == null ? (class$net$sf$jguard$jee$authentication$http$JGuardServletRequestWrapper = JGuardServletRequestWrapper.class$("net.sf.jguard.jee.authentication.http.JGuardServletRequestWrapper")) : class$net$sf$jguard$jee$authentication$http$JGuardServletRequestWrapper));
    private Map headers = null;
    private HttpServletRequest request;
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$http$JGuardServletRequestWrapper;
    static /* synthetic */ Class class$net$sf$jguard$core$principals$RolePrincipal;

    public JGuardServletRequestWrapper(HttpServletRequest req) {
        super(req);
        this.request = req;
        this.headers = new HashMap();
    }

    public boolean isUserInRole(String role) {
        String applicationName = (String)this.request.getSession(true).getServletContext().getAttribute("applicationName");
        role = RolePrincipal.getName((String)role, (String)applicationName);
        Subject subject = ((HttpAuthenticationUtils)this.request.getSession().getAttribute("authenticationUtils")).getSubject();
        Set principals = subject.getPrincipals(class$net$sf$jguard$core$principals$RolePrincipal == null ? (class$net$sf$jguard$core$principals$RolePrincipal = JGuardServletRequestWrapper.class$("net.sf.jguard.core.principals.RolePrincipal")) : class$net$sf$jguard$core$principals$RolePrincipal);
        Iterator itPrincipals = principals.iterator();
        while (itPrincipals.hasNext()) {
            Principal principal = (Principal)itPrincipals.next();
            if (!role.equals(principal.getName())) continue;
            return true;
        }
        return false;
    }

    public Principal getUserPrincipal() {
        Subject subject = ((HttpAuthenticationUtils)this.request.getSession().getAttribute("authenticationUtils")).getSubject();
        return new UserPrincipal(subject);
    }

    public String getRemoteUser() {
        Subject subject = ((HttpAuthenticationUtils)this.request.getSession().getAttribute("authenticationUtils")).getSubject();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        Iterator<Object> it = publicCredentials.iterator();
        while (it.hasNext()) {
            JGuardCredential cred = (JGuardCredential)it.next();
            if (!cred.getId().equalsIgnoreCase(LOGIN)) continue;
            return (String)cred.getValue();
        }
        try {
            Set<Object> privateCredentials = subject.getPrivateCredentials();
            Iterator<Object> it2 = privateCredentials.iterator();
            while (it2.hasNext()) {
                JGuardCredential cred2 = (JGuardCredential)it2.next();
                if (!cred2.getId().equalsIgnoreCase(LOGIN)) continue;
                return (String)cred2.getValue();
            }
        }
        catch (SecurityException sex) {
            logger.debug((Object)" you don't have the permission to look into the private Credentials of the user ", (Throwable)sex);
        }
        return null;
    }

    public void setHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
    }

    public String getHeader(String headerName) {
        if (this.headers.containsKey(headerName)) {
            return (String)this.headers.get(headerName);
        }
        return super.getHeader(headerName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

