/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.callbacks;

import com.octo.captcha.service.CaptchaService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.cert.X509Certificate;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jguard.ext.authentication.callbacks.CertificatesCallback;
import net.sf.jguard.ext.authentication.callbacks.JCaptchaCallback;
import net.sf.jguard.ext.authentication.certificates.CertificateConverter;
import net.sf.jguard.jee.authentication.http.HttpAuthenticationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.encoders.Base64;

public class HttpCallbackHandler
implements CallbackHandler {
    private static final String JAVAX_SERVLET_REQUEST_X509CERTIFICATE = "javax.servlet.request.X509Certificate";
    private static final String DIGEST_REALM = "Digest realm=\"";
    public static final String AUTHORIZATION = "Authorization";
    private static final String BASIC_REALM = "Basic realm=\"";
    private static final String NO_CACHE_AUTHORIZATION = "no-cache=\"Authorization\"";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String BASIC = "Basic ";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$jguard$jee$authentication$callbacks$HttpCallbackHandler == null ? (class$net$sf$jguard$jee$authentication$callbacks$HttpCallbackHandler = HttpCallbackHandler.class$("net.sf.jguard.jee.authentication.callbacks.HttpCallbackHandler")) : class$net$sf$jguard$jee$authentication$callbacks$HttpCallbackHandler));
    private HttpServletRequest httpRequest;
    private HttpServletResponse httpResponse;
    private String authScheme = "FORM";
    private static String loginField = "login";
    private static String passwordField = "password";
    private boolean afterRegistration;
    static /* synthetic */ Class class$net$sf$jguard$jee$authentication$callbacks$HttpCallbackHandler;

    public HttpCallbackHandler() {
    }

    public HttpCallbackHandler(HttpServletRequest request, HttpServletResponse response, String authScheme) {
        this.httpRequest = request;
        this.httpResponse = response;
        this.authScheme = authScheme;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        boolean httpRelatedAuthScheme = false;
        logger.debug((Object)("authSchemeItem=" + this.authScheme));
        String[] schemes = this.authScheme.split(",");
        List<String> authSchemes = Arrays.asList(schemes);
        Iterator<String> itAutSchemes = authSchemes.iterator();
        while (itAutSchemes.hasNext()) {
            boolean certificatesFound;
            String scheme = itAutSchemes.next();
            if (!httpRelatedAuthScheme && "FORM".equalsIgnoreCase(scheme)) {
                this.grabFormCredentials(this.httpRequest, callbacks);
                httpRelatedAuthScheme = true;
            } else if (!httpRelatedAuthScheme && "BASIC".equalsIgnoreCase(scheme)) {
                this.grabBasicCredentials(this.httpRequest, callbacks);
                httpRelatedAuthScheme = true;
            } else if (!httpRelatedAuthScheme && "DIGEST".equalsIgnoreCase(scheme)) {
                this.grabDigestCredentials(this.httpRequest, callbacks);
                httpRelatedAuthScheme = true;
            }
            if (!"CLIENT-CERT".equalsIgnoreCase(scheme) || (certificatesFound = this.grabClientCertCredentials(this.httpRequest, callbacks))) continue;
            logger.info((Object)" X509 certificates are not found ");
        }
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(HttpServletResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public static String buildBasicAuthHeader(String login, String password, String encoding) {
        String encodedString;
        if (encoding == null) {
            encoding = ISO_8859_1;
        }
        StringBuffer decodedString = new StringBuffer();
        decodedString.append(login);
        decodedString.append(" : ");
        decodedString.append(password);
        try {
            encodedString = new String(Base64.encode((byte[])decodedString.toString().getBytes(encoding)));
        }
        catch (UnsupportedEncodingException e) {
            encodedString = new String(Base64.encode((byte[])decodedString.toString().getBytes()));
        }
        StringBuffer header = new StringBuffer();
        header.append(BASIC);
        header.append(encodedString);
        header.append("==");
        return header.toString();
    }

    public static void buildBasicChallenge(HttpServletResponse response, String realmName) {
        StringBuffer responseValue = new StringBuffer();
        responseValue.append(BASIC_REALM);
        responseValue.append(realmName);
        responseValue.append("\"");
        response.setHeader(WWW_AUTHENTICATE, responseValue.toString());
        response.setHeader(CACHE_CONTROL, NO_CACHE_AUTHORIZATION);
        response.setStatus(401);
    }

    private boolean grabBasicCredentials(HttpServletRequest request, Callback[] callbacks) {
        boolean result = false;
        String login = "";
        String password = "";
        String encodedLoginAndPwd = request.getHeader(AUTHORIZATION);
        if (encodedLoginAndPwd == null || encodedLoginAndPwd.equals("")) {
            login = "guest";
            password = "guest";
        } else {
            encodedLoginAndPwd = encodedLoginAndPwd.substring(6).trim();
            String decodedLoginAndPassword = null;
            String encoding = request.getCharacterEncoding();
            if (encoding == null) {
                encoding = ISO_8859_1;
            }
            logger.debug((Object)encoding);
            try {
                decodedLoginAndPassword = new String(Base64.decode((byte[])encodedLoginAndPwd.getBytes()), encoding);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                logger.error((Object)(" encoding " + encoding + " is not supported by the platform "));
            }
            String[] parts = decodedLoginAndPassword.split(":");
            if (parts.length == 2) {
                login = parts[0].trim();
                password = parts[1].trim();
                result = true;
            }
            if (login == "" && password == "" || parts.length == 0) {
                login = "guest";
                password = "guest";
            }
        }
        this.fillBasicCredentials(callbacks, login, password);
        return result;
    }

    private boolean grabFormCredentials(HttpServletRequest request, Callback[] callbacks) {
        boolean result = false;
        HttpSession session = request.getSession();
        for (int i = 0; i < callbacks.length; ++i) {
            PasswordCallback pc;
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                String login = this.httpRequest.getParameter(loginField);
                nc.setName(login);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                pc = (PasswordCallback)callbacks[i];
                String strPwd = this.httpRequest.getParameter(passwordField);
                if (strPwd != null && strPwd != "") {
                    pc.setPassword(strPwd.toCharArray());
                    continue;
                }
                pc.setPassword(null);
                continue;
            }
            if (!(callbacks[i] instanceof JCaptchaCallback)) continue;
            pc = (JCaptchaCallback)callbacks[i];
            pc.setCaptchaAnswer(this.httpRequest.getParameter("captchaAnswer"));
            pc.setCaptchaService((CaptchaService)session.getServletContext().getAttribute("captchaService"));
            Subject subject = ((HttpAuthenticationUtils)session.getAttribute("authenticationUtils")).getSubject();
            if (subject == null || this.isAfterRegistration()) {
                pc.setSkipJCaptchaChallenge(true);
            }
            pc.setSessionID(session.getId());
        }
        result = true;
        return result;
    }

    private boolean grabDigestCredentials(HttpServletRequest request, Callback[] callbacks) {
        boolean result = false;
        String login = "";
        String password = "";
        if (login == null || password == null) {
            login = "guest";
            password = "guest";
        } else {
            result = true;
        }
        return result;
    }

    private boolean grabClientCertCredentials(HttpServletRequest request, Callback[] callbacks) {
        if (!request.isSecure()) {
            logger.warn((Object)" certificate-based authentication MUST be do in secure mode ");
            logger.warn((Object)(" but connection is do with the non secured protocol " + request.getScheme()));
            return false;
        }
        java.security.cert.X509Certificate[] certificates = null;
        X509Certificate[] oldCerts = null;
        Object[] objects = (Object[])request.getAttribute(JAVAX_SERVLET_REQUEST_X509CERTIFICATE);
        if (objects == null || objects.length == 0) {
            return false;
        }
        if (objects instanceof java.security.cert.X509Certificate[]) {
            certificates = (java.security.cert.X509Certificate[])objects;
        } else if (objects instanceof X509Certificate[]) {
            oldCerts = (X509Certificate[])objects;
            List<java.security.cert.X509Certificate> newCerts = null;
            for (int i = 0; i < oldCerts.length; ++i) {
                newCerts = Arrays.asList(certificates);
                newCerts.add(CertificateConverter.convertOldToNew((X509Certificate)oldCerts[i]));
            }
            certificates = (java.security.cert.X509Certificate[])newCerts.toArray();
        } else {
            logger.warn((Object)" X509certificates are needed but not provided by the client ");
            return false;
        }
        this.fillCertCredentials(callbacks, certificates);
        return true;
    }

    private void fillBasicCredentials(Callback[] callbacks, String login, String password) {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName(login);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(password.toCharArray());
                continue;
            }
            if (!(callbacks[i] instanceof JCaptchaCallback)) continue;
            JCaptchaCallback jc = (JCaptchaCallback)callbacks[i];
            jc.setSkipJCaptchaChallenge(true);
        }
    }

    private void fillCertCredentials(Callback[] callbacks, java.security.cert.X509Certificate[] certificates) {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof CertificatesCallback)) continue;
            CertificatesCallback cc = (CertificatesCallback)callbacks[i];
            cc.setCertificates(certificates);
            break;
        }
    }

    public static void buildFormChallenge(FilterChain chain, ServletRequest req, ServletResponse res) throws IOException, ServletException {
        chain.doFilter(req, res);
    }

    public static void buildDigestChallenge(HttpServletRequest request, HttpServletResponse response, String realm) {
        StringBuffer responseValue = new StringBuffer();
        responseValue.append(DIGEST_REALM);
        responseValue.append(realm);
        responseValue.append("\"");
        responseValue.append(",");
        responseValue.append("qop=\"");
        responseValue.append(HttpCallbackHandler.getQop());
        responseValue.append("\"");
        responseValue.append(",");
        responseValue.append("nonce=\"");
        responseValue.append(HttpCallbackHandler.getNonce(request));
        responseValue.append("\"");
        responseValue.append(",");
        responseValue.append("opaque=");
        responseValue.append("\"");
        responseValue.append(HttpCallbackHandler.getOpaque());
        responseValue.append("\"");
        responseValue.append("algorithm=");
        responseValue.append("\"");
        responseValue.append(HttpCallbackHandler.getAlgorithm());
        responseValue.append("\"");
        responseValue.append("stale=");
        responseValue.append("\"");
        responseValue.append(HttpCallbackHandler.getStale());
        responseValue.append("\"");
        response.setHeader(WWW_AUTHENTICATE, responseValue.toString());
        response.setStatus(401);
    }

    private static String getStale() {
        return "false";
    }

    private static String getQop() {
        return "auth,auth-int";
    }

    private static String getOpaque() {
        return "5ccc069c403ebaf9f0171e9517f40e41";
    }

    private static String getAlgorithm() {
        return "MD5";
    }

    private static String getNonce(HttpServletRequest request) {
        return "dcd98b7102dd2f0e8b11d0f600bfb0c093";
    }

    public static String getPasswordField() {
        return passwordField;
    }

    public static void setPasswordField(String passwordField) {
        if (passwordField != null) {
            HttpCallbackHandler.passwordField = passwordField;
        }
    }

    public static String getLoginField() {
        return loginField;
    }

    public static void setLoginField(String loginField) {
        if (loginField != null) {
            HttpCallbackHandler.loginField = loginField;
        }
    }

    public void setAfterRegistration(boolean afterRegistration) {
        this.afterRegistration = afterRegistration;
    }

    public boolean isAfterRegistration() {
        return this.afterRegistration;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

