/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.jguard.core.util.LocalizedThrowable;
import net.sf.jguard.core.util.ResourceBundleUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThrowableUtils {
    private static final Log logger = LogFactory.getLog((Class)ThrowableUtils.class);

    public static Throwable localizeThrowable(Throwable le, Locale locale) {
        logger.error((Object)("authentication failed.LoginException " + le.getMessage()), le);
        Class<?> throwableClass = le.getClass();
        Class[] clazz = new Class[]{String.class};
        try {
            Constructor<?> constructor = throwableClass.getConstructor(clazz);
            ResourceBundle rb = ResourceBundleUtils.getResourceBundle(locale);
            LocalizedThrowable localizedThrowable = new LocalizedThrowable(le, rb);
            Object[] objects = new Object[]{((Throwable)localizedThrowable).getLocalizedMessage()};
            Throwable throwable = (Throwable)constructor.newInstance(objects);
            return throwable;
        }
        catch (SecurityException e) {
            logger.error((Object)"we cannot localize LoginException for security resitrictions");
            return le;
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)"we cannot localize LoginException method not found ");
            return le;
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"we cannot localize LoginException arguments are illegal ");
            return le;
        }
        catch (InstantiationException e) {
            logger.error((Object)"we cannot localize LoginException we cannot instantiate the wrapped exception ");
            return le;
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"we cannot localize LoginException we cannot access to the exception ");
            return le;
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"we cannot localize LoginException we cannot invoke the exception ");
            return le;
        }
    }
}

