/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceBundleUtils {
    private static final String JGUARD = "JGuard";
    private static final String JGUARD_FAILSAFE = "JGuard-failsafe";
    private static final Log logger = LogFactory.getLog((Class)ResourceBundleUtils.class);

    public static ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(JGUARD, locale);
        }
        catch (MissingResourceException e) {
            logger.warn((Object)"There is not specific bundle to get messages: create a JGuard.properties and copy it to your application base classpath");
            resourceBundle = ResourceBundle.getBundle(JGUARD_FAILSAFE, locale);
        }
        return resourceBundle;
    }
}

