/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.util;

import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalizedThrowable
extends Throwable
implements Serializable {
    private static final Log logger = LogFactory.getLog((Class)LocalizedThrowable.class);
    private static final long serialVersionUID = 1L;
    private String errorKey = "";
    private Throwable cause = null;
    private ResourceBundle rb = null;

    public LocalizedThrowable(String errorKey, ResourceBundle rb) {
        this.errorKey = errorKey;
        this.rb = rb;
    }

    public LocalizedThrowable(Throwable wrappedThrowable, ResourceBundle rb) {
        this.errorKey = wrappedThrowable.getMessage();
        this.rb = rb;
    }

    public LocalizedThrowable(Throwable wrappedThrowable, Throwable cause, ResourceBundle rb) {
        this.errorKey = wrappedThrowable.getMessage();
        this.cause = cause;
        this.rb = rb;
    }

    public LocalizedThrowable(String errorKey, Throwable cause, ResourceBundle rb) {
        this.errorKey = errorKey;
        this.cause = cause;
        this.rb = rb;
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(this.rb);
    }

    public String getLocalizedMessage(ResourceBundle rb) {
        String message = null;
        try {
            message = rb.getString(this.errorKey);
        }
        catch (MissingResourceException e) {
            logger.error((Object)("Login error!!! but missing specific error key in bundle: " + this.errorKey));
            message = this.errorKey;
        }
        return message;
    }

    public Throwable getCause() {
        return this.cause;
    }
}

