/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.util;

import java.io.File;
import java.net.URI;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class FileUtils {
    private static final String FILE = "file";
    private static final Logger logger = Logger.getLogger(FileUtils.class.getName());

    public static File getFile(URI uri) {
        File file = null;
        if (uri.getScheme().equals(FILE)) {
            file = new File(uri);
        } else {
            try {
                InitialContext initContext = new InitialContext();
                file = (File)initContext.lookup(uri.toString());
            }
            catch (NamingException e) {
                logger.warning(" file cannot be found : \nthe uri (" + uri.toString() + ") pointing to it does not contains a 'file' scheme protocol or does not point to a JNDI object bound ");
                logger.warning(e.getMessage());
            }
        }
        return file;
    }
}

