/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.provisioning;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import net.sf.jguard.core.authentication.AuthenticationException;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.organization.Organization;
import net.sf.jguard.core.provisioning.EntityTemplate;
import net.sf.jguard.core.provisioning.RegistrationException;

public class SubjectTemplate
extends EntityTemplate {
    private static final Logger logger = Logger.getLogger(SubjectTemplate.class.getName());
    private Set missingPrivateRequiredCred = new HashSet();
    private Set missingPublicRequiredCred = new HashSet();
    private Set unknownPrivateOptionalCred = new HashSet();
    private Set unknownPublicOptionalCred = new HashSet();
    private Set privateRequiredCredentials;
    private Set publicRequiredCredentials;
    private Set publicOptionalCredentials;
    private Set privateOptionalCredentials = new HashSet();
    private Long id;
    private Set principals;

    public SubjectTemplate() {
        this.privateRequiredCredentials = new HashSet();
        this.publicOptionalCredentials = new HashSet();
        this.publicRequiredCredentials = new HashSet();
        this.principals = new HashSet();
    }

    public Set validateRequiredCredentialsFromUser(Subject user) throws AuthenticationException {
        HashSet missingCredentials = new HashSet();
        Set credentialsNotRegistered = null;
        Set userPublicRequiredCredentials = SubjectTemplate.getCredentials(this.getPublicRequiredCredentials(), user.getPublicCredentials(JGuardCredential.class));
        Set missingPublicCredentials = SubjectTemplate.validateCredentialSet(this.getPublicRequiredCredentials(), userPublicRequiredCredentials);
        missingCredentials.addAll(missingPublicCredentials);
        Set userPublicOptionalCredentials = SubjectTemplate.getCredentials(this.getPublicOptionalCredentials(), user.getPublicCredentials(JGuardCredential.class));
        credentialsNotRegistered = SubjectTemplate.filterCredentialSet(this.getPublicOptionalCredentials(), userPublicOptionalCredentials);
        if (credentialsNotRegistered.size() > 0) {
            logger.warning(" there are some unknown credentials filled by the user during the registration process: ");
            logger.warning(credentialsNotRegistered.toString());
        }
        Set userPrivateRequiredCredentials = SubjectTemplate.getCredentials(this.getPrivateRequiredCredentials(), user.getPrivateCredentials(JGuardCredential.class));
        Set missingPrivateCredentials = SubjectTemplate.validateCredentialSet(this.getPrivateRequiredCredentials(), userPrivateRequiredCredentials);
        missingCredentials.addAll(missingPrivateCredentials);
        Set userPrivateOptionalCredentials = SubjectTemplate.getCredentials(this.getPrivateOptionalCredentials(), user.getPrivateCredentials(JGuardCredential.class));
        credentialsNotRegistered = SubjectTemplate.filterCredentialSet(this.getPrivateOptionalCredentials(), userPrivateOptionalCredentials);
        if (credentialsNotRegistered.size() > 0) {
            logger.warning(" there are some unknown credentials filled by the user during the registration process: ");
            logger.warning(credentialsNotRegistered.toString());
        }
        return missingCredentials;
    }

    public Subject toSubject(SubjectTemplate user, Organization organization) {
        HashSet<Organization> principalsForRegisteredUsers = new HashSet<Organization>();
        principalsForRegisteredUsers.addAll(this.getPrincipals());
        principalsForRegisteredUsers.add(organization);
        Set publicCredentials = user.getPublicCredentials();
        Set privateCredentials = user.getPrivateCredentials();
        Subject subject = new Subject(false, principalsForRegisteredUsers, publicCredentials, privateCredentials);
        return subject;
    }

    public Subject toSubject(Organization organization) {
        return this.toSubject(this, organization);
    }

    public final Set getMissingPublicRequiredCred() {
        return this.missingPublicRequiredCred;
    }

    public final Set getUnknownPrivateOptionalCred() {
        return this.unknownPrivateOptionalCred;
    }

    public final Set getUnknownPublicOptionalCred() {
        return this.unknownPublicOptionalCred;
    }

    public Object clone() throws CloneNotSupportedException {
        SubjectTemplate clone = new SubjectTemplate();
        clone.setPrincipals(new HashSet(this.principals));
        clone.setPrivateOptionalCredentials(JGuardCredential.cloneCredentialsSet(this.getPrivateOptionalCredentials()));
        clone.setPrivateRequiredCredentials(JGuardCredential.cloneCredentialsSet(this.getPrivateRequiredCredentials()));
        clone.setPublicOptionalCredentials(JGuardCredential.cloneCredentialsSet(this.getPublicOptionalCredentials()));
        clone.setPublicRequiredCredentials(JGuardCredential.cloneCredentialsSet(this.getPublicRequiredCredentials()));
        return clone;
    }

    public SubjectTemplate unmodifiableSubjectTemplate() throws CloneNotSupportedException {
        SubjectTemplate readOnly = (SubjectTemplate)this.clone();
        readOnly.principals = Collections.unmodifiableSet(this.principals);
        readOnly.setPrivateOptionalCredentials(Collections.unmodifiableSet(this.getPrivateOptionalCredentials()));
        readOnly.setPrivateRequiredCredentials(Collections.unmodifiableSet(this.getPrivateRequiredCredentials()));
        readOnly.setPublicOptionalCredentials(Collections.unmodifiableSet(this.getPublicOptionalCredentials()));
        readOnly.setPublicRequiredCredentials(Collections.unmodifiableSet(this.getPublicRequiredCredentials()));
        return readOnly;
    }

    public final Set getMissingPrivateRequiredCred() {
        return this.missingPrivateRequiredCred;
    }

    public void setPrivateRequiredCredentials(Set privateCredentials) {
        this.privateRequiredCredentials = privateCredentials;
    }

    public void setPublicRequiredCredentials(Set publicCredentials) {
        this.publicRequiredCredentials = publicCredentials;
    }

    public Set getPrivateOptionalCredentials() {
        return this.privateOptionalCredentials;
    }

    public void setPrivateOptionalCredentials(Set privateOptionalCredentials) {
        this.privateOptionalCredentials = privateOptionalCredentials;
    }

    public Set getPublicOptionalCredentials() {
        return this.publicOptionalCredentials;
    }

    public void setPublicOptionalCredentials(Set publicOptionalCredentials) {
        this.publicOptionalCredentials = publicOptionalCredentials;
    }

    public Set getPublicRequiredCredentials() {
        return this.publicRequiredCredentials;
    }

    public Set getPrivateRequiredCredentials() {
        return this.privateRequiredCredentials;
    }

    public Set getPublicCredentials() {
        Set publicCredentials = this.getPublicOptionalCredentials();
        publicCredentials.addAll(this.getPublicRequiredCredentials());
        return publicCredentials;
    }

    public Set getPrivateCredentials() {
        Set privateCredentials = this.getPrivateOptionalCredentials();
        privateCredentials.addAll(this.getPrivateRequiredCredentials());
        return privateCredentials;
    }

    public Set getRequiredCredentials() {
        HashSet requiredCredentials = new HashSet(this.getPublicRequiredCredentials());
        requiredCredentials.addAll(this.getPrivateRequiredCredentials());
        return requiredCredentials;
    }

    public void validateTemplate(SubjectTemplate candidate) throws RegistrationException {
        if (candidate.getPrivateRequiredCredentials() == null) {
            logger.warning("private required credentials set from user is null ");
            candidate.setPrivateRequiredCredentials(new HashSet());
        }
        if (candidate.getPrivateOptionalCredentials() == null) {
            logger.warning("private optional credentials set from user is null ");
            candidate.setPrivateOptionalCredentials(new HashSet());
        }
        if (candidate.getPublicRequiredCredentials() == null) {
            logger.warning("public required credentials set from user is null ");
            candidate.setPublicRequiredCredentials(new HashSet());
        }
        if (candidate.getPublicOptionalCredentials() == null) {
            logger.warning("public optional credentials set from user is null ");
            candidate.setPublicOptionalCredentials(new HashSet());
        }
        this.missingPrivateRequiredCred = SubjectTemplate.validateCredentialSet(this.getPrivateRequiredCredentials(), candidate.getPrivateRequiredCredentials());
        if (this.missingPrivateRequiredCred.size() > 0) {
            throw new RegistrationException("missing private credentials required :" + this.missingPrivateRequiredCred, new HashSet(), this.missingPrivateRequiredCred);
        }
        this.missingPublicRequiredCred = SubjectTemplate.validateCredentialSet(this.getPublicRequiredCredentials(), candidate.getPublicRequiredCredentials());
        if (this.missingPrivateRequiredCred.size() > 0) {
            throw new RegistrationException("missing public credentials required :" + this.missingPublicRequiredCred, this.missingPublicRequiredCred, new HashSet());
        }
        this.unknownPrivateOptionalCred = SubjectTemplate.filterCredentialSet(this.getPrivateOptionalCredentials(), candidate.getPrivateOptionalCredentials());
        if (this.unknownPrivateOptionalCred.size() > 0) {
            logger.warning(" user has filled unknown optional private credentials :");
            logger.warning(this.unknownPrivateOptionalCred.toString());
        }
        this.unknownPublicOptionalCred = SubjectTemplate.filterCredentialSet(this.getPublicOptionalCredentials(), candidate.getPublicOptionalCredentials());
        if (this.unknownPublicOptionalCred.size() > 0) {
            logger.warning(" user has filled unknown optional public credentials :");
            logger.warning(this.unknownPublicOptionalCred.toString());
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Set getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Set principals) {
        this.principals = principals;
    }
}

