/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.provisioning;

import java.util.HashSet;
import java.util.Set;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.organization.Organization;
import net.sf.jguard.core.principals.PrincipalUtils;
import net.sf.jguard.core.provisioning.EntityTemplate;
import net.sf.jguard.core.provisioning.SubjectTemplate;

public class OrganizationTemplate
extends EntityTemplate {
    private Set credentials;
    private SubjectTemplate subjectTemplate;
    private Long id;
    public static final String ORGANIZATION_TEMPLATE = "organizationTemplate";
    private Set principals;

    public OrganizationTemplate() {
        this.credentials = new HashSet();
        this.subjectTemplate = new SubjectTemplate();
        this.principals = new HashSet();
    }

    public OrganizationTemplate(Organization organization) {
        this.credentials = new HashSet(organization.getCredentials());
        this.principals = organization.getPrincipals();
        this.subjectTemplate = organization.getSubjectTemplate();
        this.principals = new HashSet();
    }

    public Organization buildOrganization(OrganizationTemplate orga) {
        HashSet allCredentials;
        HashSet principalsForRegisteredUsers = new HashSet();
        principalsForRegisteredUsers.addAll(this.getPrincipals());
        HashSet creds = allCredentials = new HashSet(orga.getCredentials());
        HashSet principalsForOrganization = new HashSet();
        principalsForOrganization.addAll(this.getPrincipals());
        Organization organization = new Organization();
        organization.setCredentials(creds);
        organization.setPrincipals(principalsForOrganization);
        organization.setSubjectTemplate(orga.getSubjectTemplate());
        return organization;
    }

    public Organization toOrganization() {
        return this.buildOrganization(this);
    }

    public void validateTemplate(OrganizationTemplate organizationCandidate) {
        if (organizationCandidate == null) {
            throw new IllegalArgumentException(" organizationTemplate is null ");
        }
        HashSet requiredCredentialsFromCandidate = organizationCandidate.getCredentials();
        if (requiredCredentialsFromCandidate == null) {
            requiredCredentialsFromCandidate = new HashSet();
            organizationCandidate.setCredentials(requiredCredentialsFromCandidate);
        }
        EntityTemplate.filterCredentialSet(this.credentials, requiredCredentialsFromCandidate);
    }

    public SubjectTemplate getSubjectTemplate() {
        return this.subjectTemplate;
    }

    public void setSubjectTemplate(SubjectTemplate subjectTemplate) {
        this.subjectTemplate = subjectTemplate;
    }

    public Set getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Set credentials) {
        this.credentials = credentials;
    }

    public Object clone() throws CloneNotSupportedException {
        OrganizationTemplate clone = new OrganizationTemplate();
        clone.setSubjectTemplate((SubjectTemplate)this.subjectTemplate.clone());
        clone.setPrincipals(PrincipalUtils.clonePrincipalsSet(this.principals));
        clone.setCredentials(JGuardCredential.cloneCredentialsSet(this.credentials));
        return clone;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Set getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Set principals) {
        this.principals = principals;
    }
}

