/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.provisioning;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.provisioning.SubjectTemplate;

public abstract class EntityTemplate
implements Cloneable {
    private static final Logger logger = Logger.getLogger(EntityTemplate.class.getName());

    public abstract Object clone() throws CloneNotSupportedException;

    protected static Set getCredentials(Set credentialSetFromTemplate, Set credentialSetFromCandidate) {
        HashSet<JGuardCredential> creds = new HashSet<JGuardCredential>();
        Iterator itCredentialFromTemplate = credentialSetFromTemplate.iterator();
        block0: while (itCredentialFromTemplate.hasNext()) {
            JGuardCredential jcred = (JGuardCredential)itCredentialFromTemplate.next();
            Iterator itCredentialFromUser = credentialSetFromCandidate.iterator();
            while (itCredentialFromUser.hasNext()) {
                JGuardCredential jcredFromUser = (JGuardCredential)itCredentialFromUser.next();
                if (!jcred.getName().equals(jcredFromUser.getName())) continue;
                creds.add(jcred);
                continue block0;
            }
        }
        return creds;
    }

    protected static Set filterCredentialSet(Set credentialSetFromTemplate, Set credentialSetFromCandidate) {
        HashSet<JGuardCredential> credentialsNotRegistered = new HashSet<JGuardCredential>();
        Iterator itCredentialFromUser = credentialSetFromCandidate.iterator();
        while (itCredentialFromUser.hasNext()) {
            JGuardCredential jcredFromUser = (JGuardCredential)itCredentialFromUser.next();
            Iterator itCredentialFromTemplate = credentialSetFromTemplate.iterator();
            boolean found = false;
            while (itCredentialFromTemplate.hasNext()) {
                JGuardCredential jcredFromTemplate = (JGuardCredential)itCredentialFromTemplate.next();
                if (!jcredFromUser.getName().equals(jcredFromTemplate.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            credentialsNotRegistered.add(jcredFromUser);
            itCredentialFromUser.remove();
        }
        return credentialsNotRegistered;
    }

    protected static Set validateCredentialSet(Set credentialSetFromTemplate, Set credentialSetFromCandidate) {
        Iterator itCredentialFromTemplate = credentialSetFromTemplate.iterator();
        HashSet<JGuardCredential> missingCredentials = new HashSet<JGuardCredential>();
        while (itCredentialFromTemplate.hasNext()) {
            JGuardCredential jcred = (JGuardCredential)itCredentialFromTemplate.next();
            Iterator itCredentialFromUser = credentialSetFromCandidate.iterator();
            boolean found = false;
            while (itCredentialFromUser.hasNext()) {
                JGuardCredential jcredFromUser = (JGuardCredential)itCredentialFromUser.next();
                if (!jcred.getName().equals(jcredFromUser.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            missingCredentials.add(jcred);
        }
        Set credentialsNotRegistered = SubjectTemplate.filterCredentialSet(credentialSetFromTemplate, credentialSetFromCandidate);
        if (credentialsNotRegistered.size() > 0) {
            logger.warning(" there are some unknown credentials filled by the user during the registration process: ");
            logger.warning(credentialsNotRegistered.toString());
        }
        return missingCredentials;
    }
}

