/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.principals;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.organization.Organization;
import net.sf.jguard.core.principals.RolePrincipal;

public class UserPrincipal
implements Principal,
Serializable {
    private static final String NO_NAME_FOUND = "NO NAME FOUND";
    private static final long serialVersionUID = 9075426017744650798L;
    private Logger logger = Logger.getLogger(UserPrincipal.class.getName());
    private String name = "NO NAME DEFINED";
    private Subject subject;

    public UserPrincipal(Subject subject) {
        this.subject = subject;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map getPrivateCredentials() {
        Set<Object> privateCredentials = this.subject.getPrivateCredentials();
        Map pCredentials = this.transformCredentialSetIntoMap(privateCredentials);
        return pCredentials;
    }

    private Map transformCredentialSetIntoMap(Set credentials) {
        HashMap pCredentials = new HashMap();
        Iterator privateCIterator = credentials.iterator();
        while (privateCIterator.hasNext()) {
            Object credential = privateCIterator.next();
            if (!(credential instanceof JGuardCredential)) continue;
            JGuardCredential jcred = (JGuardCredential)credential;
            if (!pCredentials.containsKey(jcred.getName())) {
                HashSet<Object> values = new HashSet<Object>();
                values.add(jcred.getValue());
                pCredentials.put(jcred.getName(), values);
                continue;
            }
            Collection valuesStored = (Collection)pCredentials.get(jcred.getName());
            valuesStored.add(jcred.getValue());
        }
        return pCredentials;
    }

    public Map getPublicCredentials() {
        Set<Object> publicCredentials = this.subject.getPublicCredentials();
        Map pCredentials = this.transformCredentialSetIntoMap(publicCredentials);
        return pCredentials;
    }

    public String getName() {
        return NO_NAME_FOUND;
    }

    public boolean equals(Object object) {
        if (object instanceof UserPrincipal) {
            UserPrincipal userPrincipal = (UserPrincipal)object;
            if (((Object)this.getPrincipals()).equals(userPrincipal.getPrincipals())) {
                return true;
            }
        }
        return false;
    }

    protected Map getPrincipals() {
        Set<Principal> principals = this.subject.getPrincipals();
        HashSet<Principal> filteredSet = new HashSet<Principal>();
        Iterator<Principal> it = principals.iterator();
        while (it.hasNext()) {
            Principal principal = it.next();
            if (principal instanceof UserPrincipal) continue;
            filteredSet.add(principal);
        }
        HashMap<String, Principal> ppals = new HashMap<String, Principal>();
        Iterator itFiletedPrincipals = filteredSet.iterator();
        while (itFiletedPrincipals.hasNext()) {
            Principal principal = (Principal)itFiletedPrincipals.next();
            ppals.put(principal.getName(), principal);
        }
        return ppals;
    }

    public Map getRoles() {
        return this.getSpecificPrincipals(RolePrincipal.class);
    }

    public Organization getOrganization() {
        Set organizationSet = this.subject.getPrincipals(Organization.class);
        if (organizationSet.size() != 1) {
            throw new IllegalStateException(" a UserPrincipal object can contains only one organization. if no one is set, the default 'system' organization is used ");
        }
        return (Organization)organizationSet.iterator().next();
    }

    private Map getSpecificPrincipals(Class principalSubclass) {
        Set principals = this.subject.getPrincipals(principalSubclass);
        HashMap<String, Principal> ppals = new HashMap<String, Principal>();
        Iterator itPrincipals = principals.iterator();
        while (itPrincipals.hasNext()) {
            Principal principal = (Principal)itPrincipals.next();
            ppals.put(principal.getName(), principal);
        }
        return ppals;
    }

    public int compareTo(Object o) {
        UserPrincipal principal = (UserPrincipal)o;
        if (this.equals(o)) {
            return 0;
        }
        return this.getName().compareTo(principal.getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("UserPrincipal ");
        sb.append(this.name);
        sb.append(this.hashcode());
        return sb.toString();
    }

    public int hashcode() {
        return ((Object)this.getRoles()).hashCode() + this.getOrganization().hashCode() + ((Object)this.getPublicCredentials()).hashCode() + ((Object)this.getPrivateCredentials()).hashCode() + 45;
    }
}

