/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.principals;

import java.security.Permission;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.jguard.core.authorization.permissions.JGPermissionCollection;
import net.sf.jguard.core.organization.Organization;
import net.sf.jguard.core.principals.BasePrincipal;

public class RolePrincipal
implements BasePrincipal {
    private static final long serialVersionUID = 3761412993065431095L;
    private String localName = "";
    private String applicationName = "other";
    private Set permissionsFromDomains;
    private Set permissions = new HashSet();
    private Set orphanedPermissions;
    private Set domains;
    private boolean active = true;
    private String definition = "true";
    private Organization organization = null;
    private Long id;
    private Set descendants;

    public RolePrincipal() {
        this.domains = new HashSet();
        this.orphanedPermissions = new HashSet();
        this.permissionsFromDomains = new HashSet();
        this.descendants = new HashSet();
    }

    public RolePrincipal(String name) {
        this.setName(name);
        this.domains = new HashSet();
        this.orphanedPermissions = new HashSet();
        this.permissionsFromDomains = new HashSet();
        this.descendants = new HashSet();
    }

    public RolePrincipal(String localName, String applicationName) {
        this.localName = localName;
        this.applicationName = applicationName;
        this.domains = new HashSet();
        this.orphanedPermissions = new HashSet();
        this.permissionsFromDomains = new HashSet();
        this.descendants = new HashSet();
    }

    public RolePrincipal(String localName, String applicationName, Organization organizationOwner) {
        this.localName = localName;
        this.applicationName = applicationName;
        this.domains = new HashSet();
        this.orphanedPermissions = new HashSet();
        this.permissionsFromDomains = new HashSet();
        this.descendants = new HashSet();
        this.organization = organizationOwner;
    }

    public Object clone() {
        RolePrincipal clone = new RolePrincipal(this.localName, this.applicationName);
        clone.setDomains(new HashSet(this.domains));
        clone.setPermissions(new HashSet(this.permissions));
        clone.setDescendants(new HashSet(this.descendants));
        return clone;
    }

    public String getName() {
        return RolePrincipal.getName(this.localName, this.applicationName);
    }

    public static String getName(String localName) {
        return RolePrincipal.getName(localName, "*");
    }

    public static String getName(String localName, String applicationName) {
        StringBuffer sb = new StringBuffer(20);
        sb.append(applicationName);
        sb.append("#");
        sb.append(localName);
        return sb.toString();
    }

    public boolean equals(Object another) {
        RolePrincipal principal;
        return another instanceof RolePrincipal && (principal = (RolePrincipal)another).getName().equals(this.getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" principal class name =");
        sb.append(this.getClass().getName());
        sb.append("\n");
        sb.append(" principal localName =");
        sb.append(this.localName);
        sb.append("\n");
        sb.append(" principal application name =");
        sb.append(this.applicationName);
        sb.append("\n");
        sb.append(" organization owner =");
        sb.append(this.getOrganization());
        sb.append("\n");
        sb.append(" principal domains =");
        sb.append(this.domains);
        sb.append("\n");
        sb.append(" principal permissions =");
        sb.append(this.permissions);
        sb.append("\n");
        sb.append(" principal descendants =");
        sb.append(this.descendants);
        sb.append("\n");
        return sb.toString();
    }

    public int hashCode() {
        int i = 0;
        i += this.localName.hashCode() + this.applicationName.hashCode();
        if (this.organization != null) {
            i += this.organization.hashCode();
        }
        return i;
    }

    public void setName(String string) {
        String[] tokens = string.split("#");
        if (tokens.length == 1) {
            this.applicationName = "*";
            this.localName = tokens[0];
        } else if (tokens.length == 2) {
            this.applicationName = tokens[0];
            this.localName = tokens[1];
        } else {
            throw new IllegalArgumentException(" name is composed of applicationName#localName");
        }
    }

    public Set getAllPermissions() {
        HashSet allPermissions = new HashSet();
        allPermissions.addAll(this.permissions);
        Iterator it = this.descendants.iterator();
        while (it.hasNext()) {
            allPermissions.addAll(((RolePrincipal)it.next()).getAllPermissions());
        }
        return allPermissions;
    }

    public Set getPermissions() {
        return this.permissions;
    }

    public Set getOrphanedPermissions() {
        return this.orphanedPermissions;
    }

    public void setPermissions(Set perms) {
        Iterator itPermissionsSet = perms.iterator();
        while (itPermissionsSet.hasNext()) {
            Permission perm = (Permission)itPermissionsSet.next();
            this.addPermission(perm);
        }
    }

    public void addPermission(Permission permission) {
        this.permissions.add(permission);
        Iterator itDomains = this.domains.iterator();
        boolean orphan = true;
        while (itDomains.hasNext()) {
            JGPermissionCollection temp = (JGPermissionCollection)itDomains.next();
            if (!temp.containsPermission(permission)) continue;
            orphan = false;
            break;
        }
        if (orphan) {
            this.orphanedPermissions.add(permission);
        } else {
            this.permissionsFromDomains.add(permission);
        }
    }

    public void addDomain(JGPermissionCollection domain) {
        this.domains.add(domain);
        Set permissionsDomain = domain.getPermissions();
        this.orphanedPermissions.removeAll(permissionsDomain);
        this.permissionsFromDomains.addAll(permissionsDomain);
        this.permissions.addAll(permissionsDomain);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public Set getDomains() {
        return this.domains;
    }

    public Set getPermissionsFromDomains() {
        return this.permissionsFromDomains;
    }

    public void setDomains(Set doms) {
        Iterator it = doms.iterator();
        while (it.hasNext()) {
            JGPermissionCollection dom = (JGPermissionCollection)it.next();
            this.addDomain(dom);
        }
    }

    public int compareTo(Object o) {
        RolePrincipal principal = (RolePrincipal)o;
        if (this.equals(o)) {
            return 0;
        }
        return this.getName().compareTo(principal.getName());
    }

    public void removeDomain(JGPermissionCollection domain) {
        this.permissionsFromDomains.removeAll(domain.getPermissions());
        this.permissions.removeAll(domain.getPermissions());
        this.domains.remove(domain);
    }

    public Set getDescendants() {
        return this.descendants;
    }

    public void setDescendants(Set descendants) {
        this.descendants = descendants;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

