/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.principals;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jguard.core.principals.BasePrincipal;
import net.sf.jguard.core.principals.RolePrincipal;

public class PrincipalUtils {
    private static final Logger logger = Logger.getLogger(PrincipalUtils.class.getName());

    public static Principal getPrincipal(String className, String name) {
        Principal ppal = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "", e);
        }
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(String.class);
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, "", e);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, "", e);
        }
        if (constructor != null) {
            try {
                ppal = (Principal)constructor.newInstance(name);
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.SEVERE, "", e);
            }
            catch (InstantiationException e) {
                logger.log(Level.SEVERE, "", e);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.SEVERE, "", e);
            }
            catch (InvocationTargetException e) {
                logger.log(Level.SEVERE, "", e);
            }
        } else {
            throw new IllegalArgumentException(" the provided Class=" + className + " has'nt got any constructor with a String argument ");
        }
        return ppal;
    }

    public static Principal getPrincipal(Class clazz, Class[] parameterTypes, Object[] parameterValues) {
        Principal ppal = null;
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(parameterTypes);
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, "", e);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, "", e);
        }
        if (constructor != null) {
            try {
                ppal = (Principal)constructor.newInstance(parameterValues);
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.SEVERE, "", e);
            }
            catch (InstantiationException e) {
                logger.log(Level.SEVERE, "", e);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.SEVERE, "", e);
            }
            catch (InvocationTargetException e) {
                logger.log(Level.SEVERE, "", e);
            }
        }
        return ppal;
    }

    public static Set clonePrincipalsSet(Set principals) throws CloneNotSupportedException {
        HashSet<Object> clonedPrincipals = new HashSet<Object>();
        Iterator principalsIterator = principals.iterator();
        while (principalsIterator.hasNext()) {
            BasePrincipal ppal = (BasePrincipal)principalsIterator.next();
            clonedPrincipals.add(ppal.clone());
        }
        return clonedPrincipals;
    }

    public static void checkPrincipals(Set globalPermissions, Set principals) {
        Iterator itPrincipals = principals.iterator();
        while (itPrincipals.hasNext()) {
            RolePrincipal tempPrincipal = (RolePrincipal)itPrincipals.next();
            Set permissionsFromTemplate = tempPrincipal.getAllPermissions();
            if (globalPermissions.containsAll(permissionsFromTemplate)) continue;
            logger.warning(" principal called " + tempPrincipal.getLocalName() + " has been removed from the SubjectTemplate ");
            logger.warning(" because it contains permissions not owned by this organization throw its Principals ");
            itPrincipals.remove();
        }
    }
}

