/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.organization;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.jguard.core.organization.Organization;
import net.sf.jguard.core.principals.PrincipalUtils;
import net.sf.jguard.core.principals.RolePrincipal;
import net.sf.jguard.core.provisioning.SubjectTemplate;

public class OrganizationUtils {
    private static final Logger logger = Logger.getLogger(OrganizationUtils.class.getName());

    public static Organization findOrganization(Collection organizations, String organizationId) {
        Iterator it = organizations.iterator();
        Organization organization = null;
        while (it.hasNext()) {
            Organization orga = (Organization)it.next();
            if (!organizationId.equals(orga.getName())) continue;
            organization = orga;
            break;
        }
        return organization;
    }

    public static void checkSubjectTemplatePrincipals(SubjectTemplate template, Set ppals) {
        if (ppals == null) {
            throw new IllegalStateException(" no principals have been defined for this organization. validation of a subjectTemplate cannot be done against an empty principal list ");
        }
        Iterator itPrincipalsOwned = ppals.iterator();
        HashSet globalPermissions = new HashSet();
        while (itPrincipalsOwned.hasNext()) {
            RolePrincipal tempPrincipal = (RolePrincipal)itPrincipalsOwned.next();
            globalPermissions.addAll(tempPrincipal.getAllPermissions());
        }
        Set principalsFromTemplate = template.getPrincipals();
        PrincipalUtils.checkPrincipals(globalPermissions, principalsFromTemplate);
    }
}

