/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.organization;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import net.sf.jguard.core.authentication.AuthenticationException;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.core.organization.OrganizationUtils;
import net.sf.jguard.core.principals.BasePrincipal;
import net.sf.jguard.core.principals.PrincipalUtils;
import net.sf.jguard.core.provisioning.SubjectTemplate;

public class Organization
implements BasePrincipal,
Cloneable {
    public static final String ID = "id";
    private static final Logger logger = Logger.getLogger(Organization.class.getName());
    private AuthenticationManager authenticationManager;
    protected SubjectTemplate subjectTemplate;
    protected Set principals;
    protected Set credentials;
    protected Long id;
    protected Set users;

    public Object clone() throws CloneNotSupportedException {
        Organization clonedOrg = new Organization();
        Set clonedPrincipals = PrincipalUtils.clonePrincipalsSet(this.principals);
        clonedOrg.setPrincipals(clonedPrincipals);
        Iterator credentialsIterator = this.credentials.iterator();
        HashSet<Object> clonedCredentials = new HashSet<Object>();
        while (credentialsIterator.hasNext()) {
            JGuardCredential cred = (JGuardCredential)credentialsIterator.next();
            clonedCredentials.add(cred.clone());
        }
        clonedOrg.setCredentials(clonedCredentials);
        clonedOrg.setSubjectTemplate((SubjectTemplate)this.subjectTemplate.clone());
        return clonedOrg;
    }

    public Set getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Set principals) {
        this.principals = principals;
    }

    public boolean equals(Object organization) {
        if (!(organization instanceof Organization)) {
            return false;
        }
        Organization orga = (Organization)organization;
        Iterator itCred = this.credentials.iterator();
        JGuardCredential idCred = null;
        while (itCred.hasNext()) {
            JGuardCredential cred = (JGuardCredential)itCred.next();
            if (!ID.equals(cred.getName())) continue;
            idCred = cred;
            break;
        }
        return orga.getCredentials() != null && orga.getCredentials().contains(idCred);
    }

    public int hashCode() {
        int i = super.hashCode();
        if (this.credentials != null) {
            i = ((Object)this.credentials).hashCode();
        }
        return i;
    }

    public void addPrincipal(Principal principal) throws AuthenticationException {
        this.principals.add(principal);
    }

    public void removePrincipal(Principal principal) throws AuthenticationException {
        Set users = this.getUsers();
        Iterator itUsers = users.iterator();
        while (itUsers.hasNext()) {
            Subject user = (Subject)itUsers.next();
            Set<Principal> ppals = user.getPrincipals();
            if (!ppals.contains(principal)) continue;
            ppals.remove(principal);
        }
        this.principals.remove(principal);
    }

    public SubjectTemplate getSubjectTemplate() {
        return this.subjectTemplate;
    }

    public void setSubjectTemplate(SubjectTemplate subjectTemplate) {
        OrganizationUtils.checkSubjectTemplatePrincipals(subjectTemplate, this.principals);
        this.subjectTemplate = subjectTemplate;
    }

    public Subject createUser(SubjectTemplate user) throws AuthenticationException {
        return this.authenticationManager.createUser(user, this);
    }

    public Subject createUser(Subject user) throws AuthenticationException {
        return this.authenticationManager.createUser(user, this);
    }

    public void updateUser(JGuardCredential cred, Subject user) throws AuthenticationException {
        this.authenticationManager.updateUser(cred, user);
    }

    public Set getUsers() {
        return this.users;
    }

    public void deleteUser(Subject user) throws AuthenticationException {
        this.authenticationManager.deleteUser(user);
    }

    public void addPrincipalToUser(Subject user, String roleName) throws AuthenticationException {
    }

    public void addPrincipalToUser(Subject user, String roleName, String applicationName) throws AuthenticationException {
    }

    public Set getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Set credentials) {
        this.credentials = credentials;
    }

    public String getName() {
        Iterator it = this.credentials.iterator();
        String credentialIdValue = "";
        while (it.hasNext()) {
            JGuardCredential cred = (JGuardCredential)it.next();
            if (!cred.getName().equals(ID)) continue;
            credentialIdValue = (String)cred.getValue();
            break;
        }
        return credentialIdValue;
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(" object comapred in the compareTo method of Organization class is null");
        }
        if (!(object instanceof Organization)) {
            throw new IllegalArgumentException("object is not an Orgnaization instance");
        }
        Organization o1 = (Organization)object;
        return this.getName().compareTo(o1.getName());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUsers(Set users) {
        this.users = users;
    }
}

