/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.filters;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import net.sf.jguard.core.CoreConstants;
import net.sf.jguard.core.Filter;
import net.sf.jguard.core.FilterChain;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.AuthenticationBindings;
import net.sf.jguard.core.authentication.AuthenticationServicePoint;
import net.sf.jguard.core.authentication.AuthenticationUtils;
import net.sf.jguard.core.authentication.Stateful;
import net.sf.jguard.core.authorization.AuthorizationBindings;
import net.sf.jguard.core.authorization.PolicyDecisionPoint;
import net.sf.jguard.core.provisioning.ProvisioningServicePoint;

public class PolicyEnforcementPointFilter
implements Filter {
    private AuthenticationBindings authenticationBindings = null;
    private PolicyDecisionPoint policyDecisionPoint = null;
    private ProvisioningServicePoint provisioningServicePoint = null;
    private static final Logger logger = Logger.getLogger(PolicyEnforcementPointFilter.class.getName());
    private Permission logonProcessPermission = null;
    private Permission logoffPermission = null;
    private String authenticationScope;
    private String applicationName;
    public static final String REDIRECT = "redirect";

    public PolicyEnforcementPointFilter(Map options) {
        String authenticationBindingsImpl = (String)options.get("authenticationBindings");
        String filterConfigurationLocation = (String)options.get("configurationLocation");
        this.authenticationScope = (String)options.get(CoreConstants.AUTHENTICATION_SCOPE);
        this.applicationName = (String)options.get("applicationName");
        String authorizationBindingsImpl = (String)options.get("authorizationBindings");
        this.policyDecisionPoint = this.initPolicyDecisionPoint(authorizationBindingsImpl);
        this.authenticationBindings = PolicyEnforcementPointFilter.initAuthenticationBindings(this.policyDecisionPoint.getAuthorizationBindings(), authenticationBindingsImpl, filterConfigurationLocation, this.authenticationScope);
        this.logonProcessPermission = this.authenticationBindings.getLogonProcessPermission();
        this.logoffPermission = this.authenticationBindings.getLogoffPermission();
        String provisioningServicePointImpl = (String)options.get("provisioningServicePoint");
        if (provisioningServicePointImpl == null || "".equals(provisioningServicePointImpl)) {
            logger.info("provisioningServicePoint is not set ");
        } else {
            this.provisioningServicePoint = this.initProvisioningServicePoint(provisioningServicePointImpl, filterConfigurationLocation);
            this.policyDecisionPoint.addAlwaysGrantedPermissionsToPolicy(this.provisioningServicePoint.getGrantedPermissions());
        }
        this.policyDecisionPoint.addAlwaysGrantedPermissionsToPolicy(this.authenticationBindings.getGrantedPermissions());
    }

    public PolicyDecisionPoint getPolicyDecisionPoint() {
        return this.policyDecisionPoint;
    }

    public ProvisioningServicePoint getProvisioningServicePoint() {
        return this.provisioningServicePoint;
    }

    private PolicyDecisionPoint initPolicyDecisionPoint(String authorizationBindingsImpl) {
        logger.finest("initializing PolicyDecisionPoint");
        logger.finest("authorizationBindingsImpl=" + authorizationBindingsImpl);
        AuthorizationBindings authorizationBindings = null;
        try {
            authorizationBindings = (AuthorizationBindings)Thread.currentThread().getContextClassLoader().loadClass(authorizationBindingsImpl).newInstance();
        }
        catch (InstantiationException iex) {
            logger.log(Level.SEVERE, iex.getMessage(), iex);
            throw new IllegalArgumentException(iex.getMessage());
        }
        catch (ClassNotFoundException cne) {
            logger.log(Level.SEVERE, cne.getMessage(), cne);
            throw new IllegalArgumentException(cne.getMessage());
        }
        catch (IllegalAccessException iae) {
            logger.log(Level.SEVERE, iae.getMessage(), iae);
            throw new IllegalArgumentException(iae.getMessage());
        }
        PolicyDecisionPoint pdp = new PolicyDecisionPoint(authorizationBindings);
        return pdp;
    }

    private ProvisioningServicePoint initProvisioningServicePoint(String provisioningServicePointImpl, String filterConfigurationLocation) {
        logger.finest("initializing ProvisioningServicePoint");
        logger.finest("provisioningServicePointImpl=" + provisioningServicePointImpl);
        ProvisioningServicePoint psp = null;
        try {
            psp = (ProvisioningServicePoint)Thread.currentThread().getContextClassLoader().loadClass(provisioningServicePointImpl).newInstance();
            psp.init(filterConfigurationLocation);
        }
        catch (InstantiationException iex) {
            logger.log(Level.SEVERE, iex.getMessage(), iex);
            throw new IllegalArgumentException(iex.getMessage());
        }
        catch (ClassNotFoundException cne) {
            logger.log(Level.SEVERE, cne.getMessage(), cne);
            throw new IllegalArgumentException(cne.getMessage());
        }
        catch (IllegalAccessException iae) {
            logger.log(Level.SEVERE, iae.getMessage(), iae);
            throw new IllegalArgumentException(iae.getMessage());
        }
        return psp;
    }

    public static AuthenticationBindings initAuthenticationBindings(AuthorizationBindings authZBindings, String authenticationBindingsImpl, String filterConfigurationLocation, String authenticationScope) {
        if (authenticationBindingsImpl == null || "".equals(authenticationBindingsImpl)) {
            throw new IllegalArgumentException("authenticationBindingsImpl is null or empty");
        }
        if (filterConfigurationLocation == null || "".equals(filterConfigurationLocation)) {
            throw new IllegalArgumentException("filterConfigurationLocation is null or empty");
        }
        if (authenticationScope == null || "".equals(authenticationScope)) {
            throw new IllegalArgumentException("authenticationScope is null or empty");
        }
        logger.finest("initializing authenticationBindings");
        logger.finest("authenticationBindingsImpl=" + authenticationBindingsImpl);
        logger.finest("filterConfigurationLocation=" + filterConfigurationLocation);
        logger.finest("authenticationScope=" + authenticationScope);
        AuthenticationBindings authNBindings = null;
        try {
            Class<?> authenticationBindingsClass = Thread.currentThread().getContextClassLoader().loadClass(authenticationBindingsImpl);
            Class[] constructorArgumentTypes = new Class[]{AuthorizationBindings.class};
            Constructor<?> constructor = authenticationBindingsClass.getConstructor(constructorArgumentTypes);
            authNBindings = (AuthenticationBindings)constructor.newInstance(authZBindings);
            authNBindings.init(filterConfigurationLocation, authenticationScope);
        }
        catch (InstantiationException iex) {
            logger.log(Level.SEVERE, iex.getMessage(), iex);
            throw new IllegalArgumentException(iex.getMessage());
        }
        catch (ClassNotFoundException cne) {
            logger.log(Level.SEVERE, cne.getMessage(), cne);
            throw new IllegalArgumentException(cne.getMessage());
        }
        catch (IllegalAccessException iae) {
            logger.log(Level.SEVERE, iae.getMessage(), iae);
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalArgumentException(e.getMessage());
        }
        return authNBindings;
    }

    private boolean authenticateAfterRegistration(AccessContext context) {
        this.authenticationBindings.setRequestAttribute(context, "registrationDone", true);
        return AuthenticationServicePoint.authenticate(context, this.applicationName, this.authenticationBindings);
    }

    private void logoff(AccessContext contxt) {
        logger.finest(" logoff phase ");
        Stateful statefulAuthenticationBindings = (Stateful)((Object)this.authenticationBindings);
        AuthenticationUtils auth = (AuthenticationUtils)statefulAuthenticationBindings.getSessionAttribute(contxt, "authenticationUtils");
        if (auth != null) {
            auth.logout();
            logger.finest(" user logoff ");
        }
        statefulAuthenticationBindings.removeSessionAttribute(contxt, "authenticationUtils");
        logger.finest("doFilter() -  user logoff ");
        try {
            statefulAuthenticationBindings.invalidateSession(contxt);
        }
        catch (IllegalStateException ise) {
            logger.log(Level.SEVERE, " session is already invalidated ", ise);
        }
    }

    private void propagateWithSecurity(AccessContext contxt, Subject subject) {
        final AccessContext context = contxt;
        Subject s = subject;
        try {
            Subject.doAsPrivileged(s, new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        PolicyEnforcementPointFilter.this.policyDecisionPoint.process(context);
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, t.getMessage(), t);
                        throw new RuntimeException(t.getMessage(), t);
                    }
                    return null;
                }
            }, null);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    public void doFilter(AccessContext contxt, FilterChain chain) {
        Permission permission = this.policyDecisionPoint.getAuthorizationBindings().getPermissionRequested(contxt);
        AuthenticationUtils authNUtils = this.authenticationBindings.getAuthenticationUtils(contxt);
        Subject subject = authNUtils.getSubject();
        if (this.logonProcessPermission.implies(permission)) {
            logger.finest(" authentication phase ");
            boolean authenticationResult = AuthenticationServicePoint.authenticate(contxt, this.applicationName, this.authenticationBindings);
            logger.finest(" authentication result =" + authenticationResult);
        } else if (this.authenticationBindings.isStateful() && this.logoffPermission.implies(permission)) {
            this.logoff(contxt);
        } else if (this.provisioningServicePoint.getRegisterProcessPermission() != null && this.provisioningServicePoint.getRegisterProcessPermission().implies(permission)) {
            logger.finest(" registerProcess phase ");
            AccessContext anonymizedContext = this.provisioningServicePoint.anonymize(contxt);
            boolean authenticate = AuthenticationServicePoint.authenticate(anonymizedContext, this.applicationName, this.authenticationBindings);
            if (!authenticate) {
                return;
            }
            boolean registrationSuceed = this.provisioningServicePoint.registerProcess(contxt);
            if (registrationSuceed) {
                this.authenticateAfterRegistration(contxt);
            }
            subject = this.authenticationBindings.getAuthenticationUtils(contxt).getSubject();
        } else if (subject == null) {
            logger.finest(" subject is null  authentication phase ");
            logger.finest("LAST_ACCESS_DENIED_PERMISSION=" + permission);
            if (this.authenticationBindings.isStateful()) {
                ((Stateful)((Object)this.authenticationBindings)).setSessionAttribute(contxt, "lastAccessDeniedPermission", permission);
            }
            boolean guestAuthenticationResult = AuthenticationServicePoint.authenticateAsGuest(contxt, this.applicationName, this.authenticationBindings);
        }
        this.authenticationBindings.process(contxt);
        boolean redirect = Boolean.valueOf((String)contxt.getAttribute(REDIRECT));
        if (!redirect) {
            this.propagateWithSecurity(contxt, subject);
        }
    }
}

