/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization.policy;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Policy;
import net.sf.jguard.core.authorization.policy.MultipleAppPolicy;

public class PolicyHelper {
    public static final String GNU_JAVA_SECURITY_POLICY_FILE = "gnu.java.security.PolicyFile";
    private static final String COM_SUN_SECURITY_AUTH_POLICY_FILE = "com.sun.security.auth.PolicyFile";
    public static final String SUN_SECURITY_PROVIDER_POLICY_FILE = "sun.security.provider.PolicyFile";
    private static Logger logger = Logger.getLogger(PolicyHelper.class.getName());

    public static void installPolicyOnJVM() {
        java.security.Policy runtimePolicy = java.security.Policy.getPolicy();
        if (!runtimePolicy.getClass().getName().equals(MultipleAppPolicy.class.getName())) {
            logger.log(Level.INFO, "init() -  JGuardPolicy is not set as the policy provider . the actual policy provider is '" + runtimePolicy.getClass().getName() + "' which is different of '" + MultipleAppPolicy.class.getName() + "' ");
            logger.log(Level.INFO, "init() -  if you want the jGuard policy 'governs' all java applications (one choice among others described in the jGuard documentation),");
            logger.log(Level.INFO, "init() -  please correct the 'policy.provider' property (policy.provider=net.sf.jguard.core.JGuardPolicy) in  your 'java.security' file,");
            logger.log(Level.INFO, "init() -  located in this directory: " + System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator);
            try {
                try {
                    Class<?> clazz = Class.forName(COM_SUN_SECURITY_AUTH_POLICY_FILE);
                    Policy.setPolicy((Policy)((Policy)clazz.newInstance()));
                }
                catch (ClassNotFoundException e) {
                    logger.log(Level.WARNING, "com.sun.security.auth.PolicyFile is not reachable.\n we cannot set the old javax.security.auth.Policy implementation to it\n " + e.getMessage());
                }
                java.security.Policy.setPolicy(new MultipleAppPolicy(java.security.Policy.getPolicy()));
            }
            catch (InstantiationException e) {
                logger.log(Level.SEVERE, "init() -  Policy Implementation cannot be instantiated : InstantiationException" + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.SEVERE, "init() -  Policy Implementation cannot be accessed : IllegalAccessException" + e.getMessage(), e);
            }
            catch (SecurityException e) {
                logger.log(Level.SEVERE, "init() -  Policy Implementation cannot be defined : SecurityException . you haven't got the right to set the java policy" + e.getMessage(), e);
            }
        }
        try {
            logger.log(Level.FINE, "System properties : \n");
            Properties props = System.getProperties();
            Enumeration<Object> enumeration = props.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = (String)props.get(key);
                logger.log(Level.FINE, key + "=" + value);
            }
        }
        catch (SecurityException sex) {
            logger.log(Level.WARNING, "you have not the permission to grab system properties ");
        }
    }

    public static Class findDefaultPolicy() {
        String[] policies = new String[]{SUN_SECURITY_PROVIDER_POLICY_FILE, GNU_JAVA_SECURITY_POLICY_FILE};
        Class<?> defaultPolicyClass = null;
        for (int i = 0; i < policies.length; ++i) {
            try {
                defaultPolicyClass = Class.forName(policies[i]);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.FINE, "findDefaultPolicy() - " + policies[i] + " is not the defaultPolicy class ");
                continue;
            }
            logger.log(Level.FINE, "findDefaultPolicy() - " + policies[i] + " is the defaultPolicy class ");
            break;
        }
        if (null == defaultPolicyClass) {
            logger.log(Level.FINE, "findDefaultPolicy() -  no defaultPolicy class has been found ");
        }
        return defaultPolicyClass;
    }
}

