/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization.policy;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Set;
import javax.security.auth.Subject;
import net.sf.jguard.core.authorization.policy.ProtectionDomainUtils;

public class LocalAccessController {
    private Policy policy;

    public LocalAccessController(Policy policy) {
        this.policy = policy;
    }

    public void checkPermission(Permission permission) {
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        if (acc == null) {
            return;
        }
        if (subject == null) {
            return;
        }
        if (permission == null) {
            throw new NullPointerException(" permission provided is null ");
        }
        Set<Principal> principals = subject.getPrincipals();
        ProtectionDomain domain = ProtectionDomainUtils.getEmptyProtectionDomain(principals);
        PermissionCollection permColl = this.policy.getPermissions(domain);
        if (!permColl.implies(permission)) {
            StringBuffer sb = new StringBuffer(" permission ");
            throw new AccessControlException(sb.append(permission.toString()).append(" is not granted ").toString(), permission);
        }
    }

    public Policy getPolicy() {
        return this.policy;
    }
}

