/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization.policy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jguard.core.authorization.manager.PermissionProvider;
import net.sf.jguard.core.authorization.policy.PolicyHelper;

public abstract class JGuardPolicy
extends Policy {
    private static final String LIB = "lib";
    private static final String SECURITY = "security";
    private static final String J_GUARD_POLICY = "jGuard.policy";
    private static final String JGUARD_POLICY_LOCATION = File.separator + "lib" + File.separator + "security" + File.separator + "jGuard.policy";
    private static final String DEFAULT_POLICY = "defaultPolicy";
    private static final String JAVA_HOME = "java.home";
    protected static Policy defaultPolicy;
    private static Class policyClass;
    private static Logger logger;
    protected static final String version = "1.1.0 beta 3";

    protected void loadDefaultPolicy() {
        block11: {
            if (System.getSecurityManager() == null) {
                String javaHome = System.getProperty(JAVA_HOME);
                Properties props = new Properties();
                String defPolicy = null;
                try {
                    props.load(new FileInputStream(new File(javaHome + JGUARD_POLICY_LOCATION)));
                    defPolicy = props.getProperty(DEFAULT_POLICY);
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.CONFIG, "loadDefaultPolicy() -  jGuard.policy is not found " + e.getMessage());
                }
                catch (IOException e) {
                    logger.log(Level.CONFIG, "loadDefaultPolicy() -  jGuard.policy is not reachable " + e.getMessage());
                }
                try {
                    if (defPolicy == null) {
                        logger.log(Level.CONFIG, "loadDefaultPolicy() -  'defaultPolicy' field in the jGuard.Policy file is not defined ");
                        logger.log(Level.CONFIG, "loadDefaultPolicy() -  jGuard try to discover the default one ");
                        policyClass = PolicyHelper.findDefaultPolicy();
                        break block11;
                    }
                    policyClass = Class.forName(defPolicy);
                }
                catch (ClassNotFoundException e1) {
                    logger.log(Level.CONFIG, "loadDefaultPolicy() - the default policy class cannot be found " + e1.getMessage());
                }
            } else {
                policyClass = PolicyHelper.findDefaultPolicy();
            }
        }
        try {
            defaultPolicy = (Policy)policyClass.newInstance();
        }
        catch (InstantiationException e2) {
            logger.log(Level.CONFIG, "loadDefaultPolicy() - the default policy class cannot be instantiated" + e2.getMessage());
        }
        catch (IllegalAccessException e2) {
            logger.log(Level.CONFIG, "loadDefaultPolicy() - the default policy class cannot be accessed " + e2.getMessage());
        }
    }

    public PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection permColl = defaultPolicy.getPermissions(codesource);
        return permColl;
    }

    public abstract PermissionCollection getPermissions(ProtectionDomain var1);

    public abstract void refresh();

    protected PermissionCollection getPermissions(ProtectionDomain protectionDomain, PermissionProvider permissionProvider) {
        PermissionCollection pc = null;
        if (System.getSecurityManager() != null) {
            pc = defaultPolicy.getPermissions(protectionDomain);
        }
        if (permissionProvider != null) {
            PermissionCollection pc2 = permissionProvider.getPermissions(protectionDomain);
            if (System.getSecurityManager() != null) {
                Enumeration<Permission> enumeration = pc2.elements();
                while (enumeration.hasMoreElements()) {
                    pc.add(enumeration.nextElement());
                }
            } else {
                pc = pc2;
            }
        }
        return pc;
    }

    public abstract void addAlwaysGrantedPermissions(ClassLoader var1, Permissions var2);

    static {
        logger = Logger.getLogger(JGuardPolicy.class.getName());
    }
}

