/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization.policy;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import net.sf.jguard.core.authorization.policy.LocalAccessController;

public class AccessControllerUtils {
    private static final Logger logger = Logger.getLogger(AccessControllerUtils.class.getName());
    private static LocalAccessController accessController = null;

    public AccessControllerUtils() {
    }

    public AccessControllerUtils(Policy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(" policy is null ");
        }
        if (accessController == null) {
            accessController = new LocalAccessController(policy);
        }
    }

    public static boolean hasPermission(Subject subj, Permission p) {
        try {
            AccessControllerUtils.checkPermission(subj, p);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static void checkPermission(Subject subj, final Permission p) throws AccessControlException, PrivilegedActionException {
        try {
            Subject.doAs(subj, new PrivilegedExceptionAction(){

                public Object run() {
                    if (accessController == null) {
                        AccessController.checkPermission(p);
                    } else {
                        accessController.checkPermission(p);
                    }
                    return null;
                }
            });
        }
        catch (AccessControlException ace) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "AccessControlException ", ace);
            }
            throw ace;
        }
        catch (PrivilegedActionException pae) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "PrivilegedActionException ", pae);
            }
            throw pae;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "user has got the permission ", p);
        }
    }

    public static LocalAccessController getAccessController() {
        return accessController;
    }

    public static Policy getPolicy() {
        if (accessController == null) {
            return Policy.getPolicy();
        }
        return accessController.getPolicy();
    }
}

