/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization.policy;

import java.net.URL;
import java.security.AccessControlContext;
import java.security.CodeSource;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.Subject;
import net.sf.jguard.core.authorization.domaincombiners.RestrictDomainCombiner;
import net.sf.jguard.core.authorization.domaincombiners.StackSubjectDomainCombiner;
import net.sf.jguard.core.authorization.policy.ProtectionDomainUtils;
import net.sf.jguard.core.principals.RolePrincipal;

public class AccessControlContextUtils {
    public static AccessControlContext getRestrictedAccessControlContext(Principal principal) {
        ProtectionDomain pd = ProtectionDomainUtils.getEmptyProtectionDomain(principal);
        RestrictDomainCombiner restrictDomainCombiner = new RestrictDomainCombiner();
        AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{pd});
        AccessControlContext acc2 = new AccessControlContext(acc, restrictDomainCombiner);
        return acc2;
    }

    public static AccessControlContext getSubjectOnlyAccessControlContext(Subject subject) {
        ProtectionDomain pd = new ProtectionDomain(new CodeSource((URL)null, (Certificate[])null), null, Thread.currentThread().getContextClassLoader(), subject.getPrincipals().toArray(new Principal[subject.getPrincipals().size()]));
        ProtectionDomain[] pds = new ProtectionDomain[]{pd};
        AccessControlContext acc = new AccessControlContext(pds);
        return acc;
    }

    public static AccessControlContext getStackSubjectAccessControlContext(Subject subject) {
        ProtectionDomain[] arrayPd = new ProtectionDomain[]{};
        AccessControlContext acc = new AccessControlContext(arrayPd);
        StackSubjectDomainCombiner dc = new StackSubjectDomainCombiner(subject);
        AccessControlContext acc2 = new AccessControlContext(acc, dc);
        return acc2;
    }

    public static AccessControlContext getAccessControlContext(Collection principals) {
        Iterator itPrincipals = principals.iterator();
        ArrayList<ProtectionDomain> protectionDomains = new ArrayList<ProtectionDomain>();
        while (itPrincipals.hasNext()) {
            RolePrincipal principal = (RolePrincipal)itPrincipals.next();
            protectionDomains.add(ProtectionDomainUtils.getEmptyProtectionDomain(principal));
        }
        AccessControlContext acc = new AccessControlContext(protectionDomains.toArray(new ProtectionDomain[protectionDomains.size()]));
        return acc;
    }
}

