/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization.policy;

import java.lang.ref.WeakReference;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jguard.core.authorization.manager.PermissionProvider;
import net.sf.jguard.core.authorization.policy.JGuardPolicy;
import net.sf.jguard.core.principals.JMXPrincipal;

public abstract class AbstractMultipleAppPolicy
extends JGuardPolicy {
    private static Map permissionProviderRepository;
    private static Logger logger;

    public AbstractMultipleAppPolicy() {
        logger.log(Level.INFO, "#######   loading jGuardPolicy 1.1.0 beta 3 ###########");
        permissionProviderRepository = new WeakHashMap();
        this.loadDefaultPolicy();
    }

    public AbstractMultipleAppPolicy(Policy oldPolicy) {
        logger.log(Level.INFO, "#######   loading AbstractMultipleAppPolicy  1.1.0 beta 3 ###########");
        permissionProviderRepository = new WeakHashMap();
        defaultPolicy = oldPolicy;
    }

    public void refresh() {
        Set keys = permissionProviderRepository.keySet();
        Iterator itKeys = keys.iterator();
        while (itKeys.hasNext()) {
            Object objectID = itKeys.next();
            this.refresh(objectID);
        }
    }

    public void refresh(Object objectID) {
        PermissionProvider pm = this.getContextPermissionProvider(objectID);
        if (pm != null) {
            pm.refresh();
        }
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        ClassLoader cl = protectionDomain.getClassLoader();
        PermissionProvider pm = this.getContextPermissionProvider(cl);
        return this.getPermissions(protectionDomain, pm);
    }

    public void registerPermissionProvider(Object objectID, PermissionProvider pm) {
        if (this.getContextPermissionProvider(objectID) != null) {
            logger.log(Level.SEVERE, "registerPermissionProvider() - two webapps have got the same classLoader ....application will stop");
            throw new RuntimeException(" an exception occurs in the registerPermissionProvider method of the JGuardPolicy \n webApplication stops ");
        }
        this.setContextPermissionProvider(objectID, pm);
    }

    public void unregisterPermissionProvider(Object objectID) {
        if (permissionProviderRepository.containsKey(objectID)) {
            permissionProviderRepository.remove(objectID);
        }
    }

    public PermissionProvider getContextPermissionProvider(Object objectID) {
        WeakReference ref = (WeakReference)permissionProviderRepository.get(objectID);
        if (ref == null) {
            return null;
        }
        PermissionProvider pm = (PermissionProvider)ref.get();
        return pm;
    }

    private void setContextPermissionProvider(Object objectID, PermissionProvider pm) {
        permissionProviderRepository.put(objectID, new WeakReference<PermissionProvider>(pm));
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (domain.getClassLoader() == null) {
            Principal[] principals = domain.getPrincipals();
            boolean jmxHandled = false;
            ProtectionDomain newDomain = null;
            for (int i = 0; i < principals.length && !jmxHandled; ++i) {
                if (!(principals[i] instanceof JMXPrincipal)) continue;
                newDomain = new ProtectionDomain(domain.getCodeSource(), domain.getPermissions(), (ClassLoader)((JMXPrincipal)principals[i]).getObjectID(), domain.getPrincipals());
                jmxHandled = true;
            }
            if (newDomain != null) {
                return super.implies(newDomain, permission);
            }
        }
        return super.implies(domain, permission);
    }

    public void addAlwaysGrantedPermissions(ClassLoader cl, Permissions alwaysGrantedPermissions) {
        PermissionProvider pm = this.getContextPermissionProvider(cl);
        if (pm == null) {
            logger.severe(" classloader is not bound to a PermissionProvider registered in the MultipleAppPolicy ");
            logger.severe(" permissions always granted cannot be added ");
        } else {
            pm.addAlwaysGrantedPermissions(alwaysGrantedPermissions);
        }
    }

    static {
        logger = Logger.getLogger(AbstractMultipleAppPolicy.class.getName());
    }
}

