/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization.permissions;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jguard.core.authorization.permissions.JGPositivePermissionCollection;
import net.sf.jguard.core.authorization.permissions.URLParameter;
import net.sf.jguard.core.authorization.permissions.URLParameterCollection;

public final class URLPermission
extends BasicPermission
implements Serializable,
Cloneable,
Comparable {
    private static final Logger logger = Logger.getLogger(URLPermission.class.getName());
    public static final String DELETE = "DELETE";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String OPTIONS = "OPTIONS";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String TRACE = "TRACE";
    public static final String ANY = "ANY";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    private static final long serialVersionUID = 3257283643243574067L;
    private Pattern pattern;
    private String prettyPattern;
    private URI uri;
    private String name;
    private String description = "";
    private URLParameterCollection parameters;
    private Collection methods = new ArrayList();
    private String scheme = "ANY";
    private StringBuffer actions = new StringBuffer();

    public URLPermission(String n) {
        super(n);
        this.name = n;
        try {
            this.uri = new URI("");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.parameters = new URLParameterCollection();
    }

    public URLPermission(String name, String actions) {
        super(name);
        this.name = name;
        String[] actionsArray = actions.split(",");
        if (actionsArray.length > 4) {
            throw new IllegalArgumentException(" 'actions' argument can contain a maximum of three elements separated by ',' ");
        }
        try {
            this.setURI(actionsArray[0]);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        for (int i = 1; i < actionsArray.length; ++i) {
            if (HTTPS.equalsIgnoreCase(actionsArray[i]) || HTTP.equalsIgnoreCase(actionsArray[i])) {
                this.scheme = actionsArray[i];
                continue;
            }
            if (DELETE.equalsIgnoreCase(actionsArray[i]) || GET.equalsIgnoreCase(actionsArray[i]) || HEAD.equalsIgnoreCase(actionsArray[i]) || OPTIONS.equalsIgnoreCase(actionsArray[i]) || POST.equalsIgnoreCase(actionsArray[i]) || PUT.equalsIgnoreCase(actionsArray[i]) || TRACE.equalsIgnoreCase(actionsArray[i])) {
                this.methods.add(actionsArray[i]);
                continue;
            }
            this.description = actionsArray[i];
        }
        if (this.scheme == null) {
            this.scheme = ANY;
        }
        if (this.methods.size() == 0) {
            this.methods.add(ANY);
        }
        this.actions.append(this.prettyPattern);
        this.actions.append(',');
        this.actions.append(this.scheme);
        if (this.description.length() > 0) {
            this.actions.append(',');
            this.actions.append(this.description);
        }
    }

    private void setURI(String pPattern) throws URISyntaxException {
        String regexp = pPattern;
        regexp = URLPermission.buildRegexpFromString(URLPermission.getPathFromURIString(regexp));
        this.pattern = Pattern.compile(regexp);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "regexp=" + regexp);
        }
        String uriWithoutRegexp = URLPermission.removeRegexpFromURI(pPattern);
        this.uri = new URI(uriWithoutRegexp);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("uri=" + this.uri);
        }
        this.prettyPattern = pPattern;
        this.parameters = URLParameterCollection.getURLParameters(URLPermission.getQueryFromURIString(pPattern));
    }

    public static String removeRegexpFromURI(String uriPath) {
        uriPath = uriPath.replaceAll("\\*(?!\\*)", "");
        if (logger.isLoggable(Level.FINEST)) {
            // empty if block
        }
        uriPath = uriPath.replaceAll("\\*{2}", "\\*");
        uriPath = uriPath.replaceAll("\\$\\{", "%24%7B");
        uriPath = uriPath.replaceAll("\\}", "%7D");
        return uriPath;
    }

    public static String getPathFromURIString(String uriString) {
        String uriPath = uriString;
        int position = uriString.indexOf("?");
        if (position != -1) {
            uriPath = uriString.substring(0, position);
        }
        return uriPath;
    }

    public static String getQueryFromURIString(String uriString) {
        String uriQuery = "";
        int position = uriString.indexOf("?");
        if (position != -1) {
            uriQuery = uriString.substring(position + 1, uriString.length());
        }
        return uriQuery;
    }

    public static String buildRegexpFromString(String regexp) {
        regexp = regexp.replaceAll("\\\\", "\\\\\\\\");
        regexp = regexp.replaceAll("\\*\\*", "\\\\*\\\\*");
        regexp = regexp.replaceAll("\\?", "\\\\\\\\?");
        regexp = regexp.replaceAll("\\+", "\\\\\\\\+");
        regexp = regexp.replaceAll("\\[", "\\\\\\\\[");
        regexp = regexp.replaceAll("\\[", "\\\\\\\\]");
        regexp = regexp.replaceAll("\\^", "\\\\\\\\^");
        regexp = regexp.replaceAll("\\&", "\\\\\\\\&");
        regexp = regexp.replaceAll("\\*", "\\.\\*");
        return regexp;
    }

    public void checkGuard(Object perm) {
        Permission p = (Permission)perm;
        AccessController.checkPermission(p);
    }

    public Object clone() throws CloneNotSupportedException {
        URLPermission permission = null;
        permission = new URLPermission(this.name, this.getActions());
        return permission;
    }

    public boolean equals(Object obj) {
        if (obj instanceof URLPermission && ((URLPermission)obj).getName().equals(this.getName())) {
            URLPermission tempPerm = (URLPermission)obj;
            String[] tempActions = tempPerm.getActions().split(",");
            URI tempUri = null;
            try {
                tempUri = new URI(URLPermission.removeRegexpFromURI(tempActions[0]));
            }
            catch (URISyntaxException e) {
                logger.log(Level.SEVERE, " URI syntax error: " + URLPermission.removeRegexpFromURI(tempActions[0]), e);
            }
            if (!tempPerm.getScheme().equals(this.scheme)) {
                return false;
            }
            if (!((Object)tempPerm.getMethods()).equals(this.methods)) {
                return false;
            }
            if (this.uri.getPath().equals(tempUri.getPath())) {
                if (this.uri.getQuery() == null && tempUri.getQuery() == null) {
                    return true;
                }
                if (this.uri.getQuery() == null || tempUri.getQuery() == null) {
                    return false;
                }
                if (this.uri.getQuery().equals(tempUri.getQuery())) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String getActions() {
        return this.actions.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean implies(Permission permission) {
        boolean b;
        URLPermission urlpTemp = null;
        if (!(permission instanceof URLPermission)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, " permission is not an URLPermission. type = " + permission.getClass().getName());
            }
            return false;
        }
        urlpTemp = (URLPermission)permission;
        if (this.equals(permission)) {
            return true;
        }
        String urlpTempActions = urlpTemp.getActions();
        if (urlpTempActions == null || "".equals(urlpTempActions)) {
            return this.actions == null || "".equals(this.actions.toString());
        }
        if (!this.scheme.equals(ANY) && !this.scheme.equals(urlpTemp.getScheme())) {
            return false;
        }
        if (!this.methods.contains(ANY)) {
            ArrayList httpMethods = new ArrayList(urlpTemp.getMethods());
            httpMethods.retainAll(this.methods);
            if (httpMethods.size() == 0) {
                return false;
            }
        }
        if (!(b = this.impliesURI(urlpTemp.getURI()))) {
            return false;
        }
        b = this.impliesParameters(URLPermission.getQueryFromURIString(urlpTemp.getURI()));
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("access decision =" + b);
        }
        return b;
    }

    private boolean impliesURI(String uri) {
        String regexp = URLPermission.getPathFromURIString(uri);
        Matcher m = this.pattern.matcher(regexp);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "pattern used to check access =" + this.pattern.pattern());
            logger.log(Level.FINEST, " path to be checked =" + regexp);
        }
        boolean b = m.matches();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "access decision =" + b);
        }
        m.reset();
        return b;
    }

    private boolean impliesParameters(String queryFromUserPermission) {
        if ("".equals(queryFromUserPermission)) {
            queryFromUserPermission = null;
        }
        if (queryFromUserPermission != null && !this.parameters.isEmpty()) {
            String[] params = queryFromUserPermission.split("&");
            for (int a = 0; a < params.length; ++a) {
                String[] keyAndValue = params[a].split("=");
                URLParameter urlparam = new URLParameter();
                urlparam.setKey(keyAndValue[0]);
                String[] values = new String[]{keyAndValue.length != 1 ? keyAndValue[1] : ""};
                urlparam.setValue(values);
                if (this.parameters.implies(urlparam)) continue;
                return false;
            }
        } else {
            if (this.parameters.isEmpty() && queryFromUserPermission != null) {
                return true;
            }
            if (this.parameters.isEmpty() && queryFromUserPermission == null) {
                return true;
            }
            if (!this.parameters.isEmpty() && queryFromUserPermission == null) {
                return false;
            }
        }
        return true;
    }

    public PermissionCollection newPermissionCollection() {
        return new JGPositivePermissionCollection();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" name: " + this.name);
        sb.append("\n scheme: " + this.scheme);
        sb.append("\n parameters: " + this.parameters.toString());
        sb.append("\n pattern: " + this.pattern);
        sb.append("\n uri: " + this.uri);
        sb.append("\n description: " + this.description);
        sb.append("\n");
        return sb.toString();
    }

    public int compareTo(Object o) {
        URLPermission perm = (URLPermission)o;
        if (this.equals(perm)) {
            return 0;
        }
        return this.name.compareTo(perm.getName());
    }

    public final String getURI() {
        return this.prettyPattern;
    }

    public Collection getMethods() {
        return this.methods;
    }

    public String getScheme() {
        return this.scheme;
    }
}

